% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_bde.R
\name{theme_bde}
\alias{theme_bde}
\title{BdE \code{ggplot2} theme}
\usage{
theme_bde(...)
}
\arguments{
\item{...}{Ignored.}
}
\value{
A \code{\link[ggplot2:theme]{ggplot2::theme()}}.
}
\description{
A custom \code{ggplot2} theme based on the publications of BdE.
}
\examples{
\donttest{
library(tidyverse)

series_TC <- bde_series_full_load("TC_1_1.csv")

series_TC <- series_TC[c(1, 2)]

series_TC_pivot <- series_TC \%>\%
  filter(
    Date >= "2020-01-01" & Date <= "2020-12-31",
    !is.na(series_TC[[2]])
  )

names(series_TC_pivot) <- c("x", "y")

ggplot(series_TC_pivot, aes(x = x, y = y)) +
  geom_line(size = 0.8, color = bde_vivid_pal()(1)) +
  labs(
    title = "Title",
    subtitle = "Some metric",
    caption = "Bank of Spain"
  ) +
  theme_bde()
}

}
\seealso{
\code{\link[ggplot2:theme]{ggplot2::theme()}}
}
\concept{bde_plot}
