% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_effects.R
\name{extract}
\alias{extract}
\alias{extract.effects}
\title{Extract summary statistics}
\usage{
extract(object, ...)

\method{extract}{effects}(object, ...)
}
\arguments{
\item{object}{Object of class effects, fit via hmc.}

\item{...}{Additional arguments for methods.}
}
\value{
A list containing
\describe{
\item{summary}{Rstan summary of parameters from model.}
\item{flagged}{Vector of parameter names with Rhat > 1.1.}
}
}
\description{
Extract summary statistics
}
\section{Methods (by class)}{
\itemize{
\item \code{effects}: Extract summary statistics from HMC effects object

Extracts the summary information in a form conducive with vis methods,
specifically in cases when return_summary was set to FALSE.
}}

\examples{
formula <- ~DIAGNOSIS
refs <- 'Not IBD'

dat <- prepare_data(otu_table=GEVERS$OTU,rows_are_taxa=FALSE,tax_table=GEVERS$TAX,
                    metadata=GEVERS$META,formula=formula,refs=refs,
                    cn_normalize=TRUE,drop=TRUE)

\dontrun{
topics <- find_topics(dat,K=15)

functions <- predict(topics,reference_path='/references/ko_13_5_precalculated.tab.gz')

function_effects <- est(functions,level=3,
                        iters=500,method='hmc',
                        prior=c('laplace','t','laplace'),
                        return_summary=FALSE)

function_effects_summary <- extract(function_effects)
}

}
