% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{layer_autoregressive}
\alias{layer_autoregressive}
\title{Masked Autoencoder for Distribution Estimation}
\usage{
layer_autoregressive(object, params, event_shape = NULL,
  hidden_units = NULL, input_order = "left-to-right",
  hidden_degrees = "equal", activation = NULL, use_bias = TRUE,
  kernel_initializer = "glorot_uniform", validate_args = FALSE, ...)
}
\arguments{
\item{object}{Model or layer object}

\item{params}{integer specifying the number of parameters to output per input.}

\item{event_shape}{\code{list}-like of positive integers (or a single int),
specifying the shape of the input to this layer, which is also the
event_shape of the distribution parameterized by this layer.  Currently
only rank-1 shapes are supported.  That is, event_shape must be a single
integer.  If not specified, the event shape is inferred when this layer
is first called or built.}

\item{hidden_units}{\code{list}-like of non-negative integers, specifying
the number of units in each hidden layer.}

\item{input_order}{Order of degrees to the input units: 'random',
'left-to-right', 'right-to-left', or an array of an explicit order. For
example, 'left-to-right' builds an autoregressive model:
\code{p(x) = p(x1) p(x2 | x1) ... p(xD | x<D)}.  Default: 'left-to-right'.}

\item{hidden_degrees}{Method for assigning degrees to the hidden units:
'equal', 'random'.  If 'equal', hidden units in each layer are allocated
equally (up to a remainder term) to each degree.  Default: 'equal'.}

\item{activation}{An activation function.  See \code{keras::layer_dense}. Default: \code{NULL}.}

\item{use_bias}{Whether or not the dense layers constructed in this layer
should have a bias term.  See \code{keras::layer_dense}.  Default: \code{TRUE}.}

\item{kernel_initializer}{Initializer for the kernel weights matrix.  Default: 'glorot_uniform'.}

\item{validate_args}{\code{logical}, default \code{FALSE}. When \code{TRUE}, layer
parameters are checked for validity despite possibly degrading runtime
performance. When \code{FALSE} invalid inputs may silently render incorrect outputs.}

\item{...}{Additional keyword arguments passed to the \code{keras::layer_dense} constructed by this layer.}
}
\value{
a Keras layer
}
\description{
\code{layer_autoregressive} takes as input a Tensor of shape \code{[..., event_size]}
and returns a Tensor of shape \code{[..., event_size, params]}.
The output satisfies the autoregressive property.  That is, the layer is
configured with some permutation \code{ord} of \code{{0, ..., event_size-1}} (i.e., an
ordering of the input dimensions), and the output \code{output[batch_idx, i, ...]}
for input dimension \code{i} depends only on inputs \code{x[batch_idx, j]} where
\code{ord(j) < ord(i)}.
}
\details{
The autoregressive property allows us to use
\code{output[batch_idx, i]} to parameterize conditional distributions:
\code{p(x[batch_idx, i] | x[batch_idx, ] for ord(j) < ord(i))}
which give us a tractable distribution over input \code{x[batch_idx]}:

\code{p(x[batch_idx]) = prod_i p(x[batch_idx, ord(i)] | x[batch_idx, ord(0:i)])}

For example, when \code{params} is 2, the output of the layer can parameterize
the location and log-scale of an autoregressive Gaussian distribution.
}
\seealso{
Other layers: \code{\link{layer_conv_1d_flipout}},
  \code{\link{layer_conv_1d_reparameterization}},
  \code{\link{layer_conv_2d_flipout}},
  \code{\link{layer_conv_2d_reparameterization}},
  \code{\link{layer_conv_3d_flipout}},
  \code{\link{layer_conv_3d_reparameterization}},
  \code{\link{layer_dense_flipout}},
  \code{\link{layer_dense_local_reparameterization}},
  \code{\link{layer_dense_reparameterization}},
  \code{\link{layer_dense_variational}},
  \code{\link{layer_variable}}
}
\concept{layers}
