% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ide.R
\name{ide}
\alias{ide}
\title{Identification plots}
\usage{
ide(
  Y,
  transf = list(),
  order.polreg = 0,
  lag.max = NULL,
  wn.bands = TRUE,
  graphs = c("plot", "acf", "pacf"),
  set.layout = TRUE,
  byrow = TRUE,
  main = "",
  ...
)
}
\arguments{
\item{Y}{Univariate or multivariate time series.}

\item{transf}{Data transformations, list(bc = F, d = 0, D = 0, S = F),
where bc is the Box-Cox logarithmic transformation, d and D are the
number of nonseasonal and seasonal differences, and S is the annual 
sum operator.}

\item{order.polreg}{an integer indicating the order of a polynomial trend.}

\item{lag.max}{number of autocorrelations.}

\item{wn.bands}{logical. If TRUE confidence intervals for sample 
autocorrelations are computed assuming a white noise series.}

\item{graphs}{graphs to be shown: plot, hist, acf, pacf, pgram, 
cpgram (cummulative periodogram), rm (range-median).}

\item{set.layout}{logical. If TRUE the layout is set by the function,
otherwise it is set by the user.}

\item{byrow}{logical. If TRUE the layout is filled by rows, otherwise it 
is filled by columns.}

\item{main}{title of the graph.}

\item{...}{additional arguments.}
}
\description{
\code{ide} displays graphs useful to identify a tentative ARIMA 
model for a time series.
}
\examples{
Y <- AirPassengers
ide(Y, graphs = c("plot", "rm"))
ide(Y, transf = list(list(bc = TRUE, S = TRUE), list(bc = TRUE, d = 1, D = 1)))

}
