% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_word.R
\name{split_word}
\alias{split_word}
\alias{split_word.default}
\alias{split_word.data.frame}
\title{Split Words}
\usage{
split_word(x, ...)

\method{split_word}{default}(x, lower = TRUE, ...)

\method{split_word}{data.frame}(x, text.var = TRUE, lower = TRUE, ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with words.}

\item{lower}{logical.  If \code{TRUE} the words are converted to lower case.}

\item{text.var}{The name of the text variable.  If \code{TRUE}
\code{split_word} tries to detect the text column with words.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of vectors of words or an expanded
\code{\link[data.table]{data.table}} with words split apart.
}
\description{
Split words.
}
\examples{
(x <- c(
    "Mr. Brown comes! He says hello. i give him coffee.",
    "I'll go at 5 p. m. eastern time.  Or somewhere in between!",
    "go there"
))
split_word(x)
split_word(x, lower=FALSE)

data(DATA)
split_word(DATA)
split_word(DATA, lower=FALSE)

## Larger data set
split_word(hamlet)
}
