% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_index.R
\name{change_index}
\alias{change_index}
\title{Indexing of Changes in Runs}
\usage{
change_index(x, ...)
}
\arguments{
\item{x}{A vector.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of integer indices of where a vector initially changes.
}
\description{
Find the indices of changes in runs in a vector.  This function pairs well with
\code{split_index} and is the default for the \code{indices} in all \code{split_index}
functions that act on atomic vectors.
}
\examples{
set.seed(10)
(x <- sample(0:1, 20, TRUE))
change_index(x)
split_index(x, change_index(x))


(p_chng <- change_index(CO2[["Plant"]]))
split_index(CO2[["Plant"]], p_chng)
}
\seealso{
\code{\link[textshape]{split_index}}
}

