% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_to.R
\name{from_to}
\alias{from_to}
\alias{from_to.character}
\alias{from_to.data.frame}
\alias{from_to.default}
\alias{from_to.numeric}
\alias{from_to_summarize}
\title{Prepare Discourse Data for Network Plotting}
\usage{
from_to(x, ...)

\method{from_to}{default}(x, final = "End", ...)

\method{from_to}{character}(x, final = "End", ...)

\method{from_to}{numeric}(x, final = "End", ...)

\method{from_to}{data.frame}(x, from.var, final = "End",
  as.tibble = tibble_output(), ...)

from_to_summarize(x, from.var, id.vars = NULL, text.var = TRUE,
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A data form \code{vector} or \code{data.frame}.}

\item{final}{The name of the closing element or node.}

\item{from.var}{A character string naming the column to be considered the
origin of the talk.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{id.vars}{The variables that correspond to the speaker or are attributes
of the speaker (from variable).}

\item{text.var}{The name of the text variable.  If \code{TRUE}
\code{duration} tries to detect the text column.}

\item{\ldots}{Ignored.}
}
\value{
Returns a vector (if given a vector) or an augmented
\code{\link[data.table]{data.table}}.
}
\description{
\code{from_to} - Add the next speaker as the from variable in a to/from
network data structure.  Assumes that the flow of discourse is coming from
person A to person B, or at the very least the talk is taken up by person B.
Works by taking the vector of speakers and shifting everything down one and
then adding a closing element.

\code{from_to_summarize} - A wrapper for \code{from_to.data.frame} that
adds a \code{word.count} column and then combines duplicate rows.
}
\examples{
from_to(DATA, 'person')
from_to_summarize(DATA, 'person')
from_to_summarize(DATA, 'person', c('sex', 'adult'))
\dontrun{
if (!require("pacman")) install.packages("pacman"); library(pacman)
p_load(dplyr, geomnet, qdap, stringi, scales)
p_load_current_gh('trinker/textsahpe')

dat <- from_to_summarize(DATA, 'person', c('sex', 'adult')) \%>\%
    mutate(words = rescale(word.count, c(.5, 1.5)))

dat \%>\%
    ggplot(aes(from_id = from, to_id = to)) +
        geom_net(
            aes(linewidth = words),
            layout.alg = "fruchtermanreingold",
            directed = TRUE,
            labelon = TRUE,
            size = 1,
            labelcolour = 'black',
            ecolour = "grey70",
            arrowsize = 1,
            curvature = .1
        ) +
        theme_net() +
        xlim(c(-0.05, 1.05))
}
}

