% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedding_glove.R
\name{embedding_glove}
\alias{embedding_glove}
\alias{embedding_glove6b}
\alias{embedding_glove27b}
\alias{embedding_glove42b}
\alias{embedding_glove840b}
\title{Global Vectors for Word Representation}
\source{
\url{https://nlp.stanford.edu/projects/glove/}
}
\usage{
embedding_glove6b(
  dir = NULL,
  dimensions = c(50, 100, 200, 300),
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)

embedding_glove27b(
  dir = NULL,
  dimensions = c(25, 50, 100, 200),
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)

embedding_glove42b(
  dir = NULL,
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)

embedding_glove840b(
  dir = NULL,
  delete = FALSE,
  return_path = FALSE,
  clean = FALSE,
  manual_download = FALSE
)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{dimensions}{A number indicating the number of vectors to include. One
of 50, 100, 200, or 300 for glove6b, or one of 25, 50, 100, or 200 for
glove27b.}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}

\item{clean}{Logical, set \code{TRUE} to remove intermediate files. This can
greatly reduce the size. Defaults to FALSE.}

\item{manual_download}{Logical, set \code{TRUE} if you have manually
downloaded the file and placed it in the folder designated by running
this function with \code{return_path = TRUE}.}
}
\value{
A tibble with 400k, 1.9m, 2.2m, or 1.2m rows (one row for each unique
  token in the vocabulary) and the following variables:
\describe{
  \item{token}{An individual token (usually a word)}
  \item{d1, d2, etc}{The embeddings for that token.}
}
}
\description{
The GloVe pre-trained word vectors provide word embeddings created using
varying numbers of tokens.
}
\details{
Citation info:

InProceedings\{pennington2014glove, \cr
author     = \{Jeffrey Pennington and Richard Socher and Christopher D. \cr
               Manning\}, \cr
title      = \{GloVe: Global Vectors for Word Representation\}, \cr
booktitle  = \{Empirical Methods in Natural Language Processing (EMNLP)\}, \cr
year       = 2014 \cr
pages      = \{1532-1543\} \cr
url        = \{http://www.aclweb.org/anthology/D14-1162\} \cr
\}
}
\examples{
\dontrun{
embedding_glove6b(dimensions = 50)

# Custom directory
embedding_glove42b(dir = "data/")

# Deleting dataset
embedding_glove6b(delete = TRUE, dimensions = 300)

# Returning filepath of data
embedding_glove840b(return_path = TRUE)
}
}
\references{
Jeffrey Pennington, Richard Socher, and Christopher D. Manning.
  2014. GloVe: Global Vectors for Word Representation.
}
\concept{embeddings}
\keyword{datasets}
