% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_dbpedia.R
\name{dataset_dbpedia}
\alias{dataset_dbpedia}
\title{DBpedia Ontology Dataset}
\source{
\url{https://papers.nips.cc/paper/5782-character-level-convolutional-networks-for-text-classification.pdf}

\url{https://wiki.dbpedia.org/}

\url{https://github.com/le-scientifique/torchDatasets/raw/master/dbpedia_csv.tar.gz}
}
\usage{
dataset_dbpedia(dir = NULL, split = c("train", "test"),
  delete = FALSE, return_path = FALSE, clean = FALSE)
}
\arguments{
\item{dir}{Character, path to directory where data will be stored. If
\code{NULL}, \link[rappdirs]{user_cache_dir} will be used to determine path.}

\item{split}{Character. Return training ("train") data or testing ("test")
data. Defaults to "train".}

\item{delete}{Logical, set \code{TRUE} to delete dataset.}

\item{return_path}{Logical, set \code{TRUE} to return the path of the dataset.}

\item{clean}{Logical, set \code{TRUE} to remove intermediate files. This can
greatly reduce the size. Defaults to FALSE.}
}
\value{
A tibble with 560,000 or 70,000 rows for "train" and "test"
    respectively and 3 variables:
\describe{
  \item{class}{Character, denoting the class class}
  \item{title}{Character, title of article}
  \item{description}{Character, description of article}
}
}
\description{
DBpedia ontology dataset classification dataset. It contains 560,000 training
samples and 70,000 testing samples for each of 14 nonoverlapping classes
from DBpedia.
}
\details{
The classes are

\itemize{
\item Company
\item EducationalInstitution
\item Artist
\item Athlete
\item OfficeHolder
\item MeanOfTransportation
\item Building
\item NaturalPlace
\item Village
\item Animal
\item Plant
\item Album
\item Film
\item WrittenWork
}
}
\examples{
\donttest{
dataset_dbpedia()

# Custom directory
dataset_dbpedia(dir = "data/")

# Deleting dataset
dataset_dbpedia(delete = TRUE)

# Returning filepath of data
dataset_dbpedia(return_path = TRUE)

# Access both training and testing dataset
train <- dataset_dbpedia(split = "train")
test <- dataset_dbpedia(split = "test")
}

}
\seealso{
Other topic: \code{\link{dataset_ag_news}},
  \code{\link{dataset_trec}}
}
\concept{topic}
\keyword{datasets}
