% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_to.R
\name{replace_to}
\alias{replace_to}
\alias{replace_from}
\title{Grab Begin/End of String to/from Character}
\usage{
replace_to(x, char = " ", n = 1, include = FALSE, ...)

replace_from(x, char = " ", n = 1, include = FALSE, ...)
}
\arguments{
\item{x}{A character string}

\item{char}{The character from which to grab until/from.}

\item{n}{Number of times the character appears before the grab.}

\item{include}{logical.  If \code{TRUE} includes the character in the grab.}

\item{\ldots}{ignored.}
}
\value{
returns a vector of text with begin/end of string to/from character removed.
}
\description{
\code{replace_to} - Grab from beginning of string to a character(s).

\code{replace_from} - Grab from character(s) to end of string.
}
\examples{
\dontrun{
x <- c("a_b_c_d", "1_2_3_4", "<_?_._:")
replace_to(x, "_")
replace_to(x, "_", 2)
replace_to(x, "_", 3)
replace_to(x, "_", 4)
replace_to(x, "_", 3, include=TRUE)

replace_from(x, "_")
replace_from(x, "_", 2)
replace_from(x, "_", 3)
replace_from(x, "_", 4)
replace_from(x, "_", 3, include=TRUE)

x2 <- gsub("_", " ", x)
replace_from(x2, " ", 2)
replace_to(x2, " ", 2)

x3 <- gsub("_", "\\\\^", x)
replace_from(x3, "^", 2)
replace_to(x3, "^", 2)

x4 <- c("_a_b", "a__b")
replace_from(x4, "_", 1)
replace_to(x4, "_", 1)
}
}
\references{
\url{http://stackoverflow.com/q/15909626/1000343}
}
\author{
Josh O'Brien and Tyler Rinker <tyler.rinker@gmail.com>.
}
