% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glove.R
\name{glove}
\alias{glove}
\alias{glove.Matrix}
\alias{glove.dgTMatrix}
\title{Perform fit of the GloVe model.}
\usage{
glove(tcm, vocabulary_size, word_vectors_size, x_max, num_iters,
  shuffle_seed = NA_integer_, learning_rate = 0.05, verbose = TRUE,
  convergence_threshold = 0, grain_size = 100000L, max_cost = 10,
  alpha = 0.75, ...)

\method{glove}{dgTMatrix}(tcm, vocabulary_size = nrow(tcm), word_vectors_size,
  x_max, num_iters, shuffle_seed = NA_integer_, learning_rate = 0.05,
  verbose = TRUE, convergence_threshold = -1, grain_size = 100000L,
  max_cost = 10, alpha = 0.75, ...)

\method{glove}{Matrix}(tcm, ...)
}
\arguments{
\item{tcm}{object which represents Term-Coocurence matrix, which used in training.
At the moment only \code{dgTMatrix} or (coercible to \code{dgTMatrix}) is supported.
In future releases we will add support for out-of-core learning and streaming TCM from disk.}

\item{vocabulary_size}{number of words in underlying Term-Coocurence matrix}

\item{word_vectors_size}{desired dimenson for word vectors}

\item{x_max}{maximum number of cooccurences to use in weighting function.
See GloVe paper for details: \url{http://nlp.stanford.edu/pubs/glove.pdf}}

\item{num_iters}{number of AdaGrad epochs}

\item{shuffle_seed}{\code{logical} whether to perform shuffling before each SGD iteration.
Generally this is good idea, but from my experience, in this particular case,
it doesn't improve convergence. So, there is  no shuffling by default:
\code{shuffle_seed = NA_integer_}. Please report, if you find that
shuffling improves your score.}

\item{learning_rate}{learning rate for SGD, I don't recommend to modify this parameter,
AdaGrad will quickly adjust it to optimal.}

\item{verbose}{whether to display training inforamtion}

\item{convergence_threshold}{defines early stopping stratergy. We stop fitting when
one of two following conditions will be satisfied:
a)  spent all iterations

or

b) \code{cost_previous_iter} / \code{cost_current_iter} - 1 < convergence_threshold}

\item{grain_size}{I don't recommend to adjust this paramenter. This is the grain_size
for \code{RcppParallel::parallelReduce}.
See \url{http://rcppcore.github.io/RcppParallel/#grain-size} for details.}

\item{max_cost}{the maximum absolute value of calculated
gradient for any single co-occurrence pair. Try to set to smaller vaue if you have
problems with numerical stability.}

\item{alpha}{alpha in weighting function formula :
\eqn{f(x) = 1 if x > x_max; else (x/x_max)^alpha }}

\item{...}{arguments passed to other methods (not used at the moment).
Generelly good idea for stochastic gradient descent}
}
\description{
Train GloVe word embeddings model via fully asynchronous parallel AdaGrad.
}
\section{Methods (by class)}{
\itemize{
\item \code{dgTMatrix}: fits GloVe model on dgTMatrix - sparse Matrix in triplet form

\item \code{Matrix}: fits GloVe model on Matrix input
}}
\examples{
\dontrun{
text8 <- read_lines('./text8')
it <- itoken(text8, preprocess_function = identity,
             tokenizer = function(x) str_split(x, fixed(" ")))
vocab <- vocabulary(it) \%>\%
 prune_vocabulary(term_count_min = 5)

it <- itoken(text8, preprocess_function = identity,
             tokenizer = function(x) str_split(x, fixed(" ")))

corpus <- create_vocab_corpus(iterator = it,
                              vocabulary = vocab,
                              grow_dtm = FALSE,
                              skip_grams_window = 5)
tcm <- get_tcm(corpus)

RcppParallel::setThreadOptions(numThreads = 8)
fit <- glove(tcm = tcm, shuffle_seed = 1L, word_vectors_size = 50,
              x_max = 10, learning_rate = 0.2,
              num_iters = 50, grain_size = 1e5,
              max_cost = 100, convergence_threshold = 0.01)
word_vectors <- fit$word_vectors[[1]] + fit$word_vectors[[2]]
rownames(word_vectors) <- rownames(tcm)
qlst <- prepare_analogue_questions('./questions-words.txt', rownames(word_vectors))
res <- check_analogue_accuracy(questions_lst = qlst, m_word_vectors = word_vectors)
}
}
\seealso{
\url{http://nlp.stanford.edu/projects/glove/}
}

