% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnw-tools.R
\name{rnw_to_rmd}
\alias{rnw_to_rmd}
\title{Sweave to RMarkdown}
\usage{
rnw_to_rmd(
  input_file,
  output_format,
  clean_up = TRUE,
  autonumber_eq = FALSE,
  autonumber_sec = TRUE,
  suppress_package_startup_message = FALSE,
  kable_tab = TRUE,
  fig_in_r = TRUE,
  algorithm_render = FALSE
)
}
\arguments{
\item{input_file}{input Sweave file path}

\item{output_format}{knit output type for the RMarkdown file options for "bookdown", "biocstyle", "litedown"}

\item{clean_up}{whether to clean up the intermediate files, default is TRUE}

\item{autonumber_eq}{whether to autonumber the equations, default is FALSE}

\item{autonumber_sec}{whether to autonumber the sections, default is TRUE}

\item{suppress_package_startup_message}{whether to suppress the package startup message, default is FALSE}

\item{kable_tab}{converts to kable table instead of markdown tables}

\item{fig_in_r}{whether to include figures in R code chunks, default is TRUE}

\item{algorithm_render}{Enable to include algorithms with pseudocode.js, default is FALSE optional is TRUE}
}
\value{
True if R Markdown file successfully generated in the same folder
}
\description{
automated function for converting a single Sweave file to R Markdown file
}
\note{
Use pandoc version greater than or equal to 3.1
}
\examples{
# move example Sweave article and associated files to a temporary directory
example_dir <- system.file("examples", "sweave_article", package = "texor")
file.copy(from = example_dir, to = tempdir(), recursive = TRUE)
article_dir <- file.path(tempdir(), "sweave_article")

# convert example Sweave article to Rmd
rnw_to_rmd(file.path(article_dir, "example.Rnw"),
           output_format = "bookdown",
           clean_up = TRUE,
           autonumber_eq = TRUE,
           autonumber_sec = FALSE)

# convert Rmd to HTML (comment this step to avoid failure on R CMD Check)
# rmarkdown::render(file.path(article_dir, "example.Rmd"))
# browseURL(file.path(article_dir, "example.html"))

# remove temporary files
unlink(article_dir, recursive = TRUE)
}
