% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify-output.R
\name{verify_output}
\alias{verify_output}
\title{Verify output}
\usage{
verify_output(path, code, width = 80, crayon = FALSE)
}
\arguments{
\item{path}{Path to save file. Typically this will be a call to
\code{\link[=test_path]{test_path()}} so that the same path when the code is run interactively.}

\item{code}{Code to execute.}

\item{width}{Width of console output}

\item{crayon}{Enable crayon package colouring?}
}
\description{
This is a regression test records interwoven code and output into a file,
similar to Rmd. It's designed particularly for testing print methods and
error messages, where the primary goal is to ensure that the output is
helpful to a human. Obviously, there's no way to test that automatically,
so the best we can do is make the results explicit by saving to a text file.
This makes the presentation easier to see in code reviews, and avoids
changing it accidentally.
}
\section{CRAN}{

On CRAN, \code{verify_output()} will not fail if the output changes. This is
beause tests of print methods and error messages are often fragile due to
implicit dependencies on other packages, and failure does not imply
incorrect computation, just a change in presentation.
}

\section{Differences to Rmd}{

\code{verify_output()} can only capture the abstract syntax tree, losing all
whitespace and comments. To mildy offset this limitation, bare string
are turned into comments.
}

