% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectation.R
\name{expect}
\alias{expect}
\title{The building block of all \code{expect_} functions}
\usage{
expect(ok, failure_message, info = NULL, srcref = NULL)
}
\arguments{
\item{ok}{\code{TRUE} or \code{FALSE} indicating if the expectation was successful.}

\item{failure_message}{Message to show if the expectation failed.}

\item{info}{Character vector continuing additional information. Included
for backward compatibility only and new expectations should not use it.}

\item{srcref}{Location of the failure. Should only needed to be explicitly
supplied when you need to forward a srcref captured elsewhere.}
}
\value{
An expectation object. Signals the expectation condition
with a \code{continue_test} restart.
}
\description{
Call this function when writing your own expectations. See
\code{vignette("custom-expectation")} for details.
}
