% Generated by roxygen2 (4.0.0): do not edit by hand
\name{equals}
\alias{equals}
\alias{expect_equal}
\title{Expectation: is the object equal (with numerical tolerance) to a value?}
\usage{
equals(expected, label = NULL, ...)

expect_equal(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
  \item{expected}{Expected value}

  \item{label}{For full form, label of expected object used
  in error messages. Useful to override default (deparsed
  expected expression) when doing tests in a loop.  For
  short cut form, object label. When \code{NULL}, computed
  from deparsed object.}

  \item{expected.label}{Equivalent of \code{label} for
  shortcut form.}

  \item{...}{other values passed to
  \code{\link{all.equal}}}

  \item{object}{object to test}

  \item{info}{extra information to be included in the
  message (useful when writing tests in loops).}
}
\description{
Comparison performed using \code{\link{all.equal}}.
}
\examples{
a <- 10
expect_that(a, equals(10))
expect_equal(a, 10)

# Use equals() when testing for numeric equality
sqrt(2) ^ 2 - 1
expect_that(sqrt(2) ^ 2, equals(2))
expect_equal(sqrt(2) ^ 2, 2)
# Neither of these forms take floating point representation errors into
# account
\dontrun{
expect_that(sqrt(2) ^ 2 == 2, is_true())
expect_that(sqrt(2) ^ 2, is_identical_to(2))
}

# You can pass on additional arguments to all.equal:
\dontrun{
# Test the ABSOLUTE difference is within .002
expect_equal(object = 10.01, expected = 10, tolerance = .002,
  scale = 1)

# Test the RELATIVE difference is within .002
expectedValue <- 10
expect_equal(object = 10.01, expected = expectedValue, tolerance = 0.002,
  scale = expectedValue)
}
}
\seealso{
Other expectations: \code{\link{expect-compare}},
  \code{\link{expect_less_than}},
  \code{\link{expect_more_than}},
  \code{\link{is_less_than}}, \code{\link{is_more_than}};
  \code{\link{expect_equivalent}},
  \code{\link{is_equivalent_to}};
  \code{\link{expect_error}}, \code{\link{throws_error}};
  \code{\link{expect_false}}, \code{\link{is_false}};
  \code{\link{expect_identical}},
  \code{\link{is_identical_to}}; \code{\link{expect_is}},
  \code{\link{is_a}}; \code{\link{expect_match}},
  \code{\link{matches}}; \code{\link{expect_message}},
  \code{\link{shows_message}}; \code{\link{expect_named}},
  \code{\link{has_names}}; \code{\link{expect_null}},
  \code{\link{is_null}}; \code{\link{expect_output}},
  \code{\link{prints_text}}; \code{\link{expect_true}},
  \code{\link{is_true}}; \code{\link{expect_warning}},
  \code{\link{gives_warning}};
  \code{\link{takes_less_than}}
}

