% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{delaunay}
\alias{delaunay}
\title{Delaunay triangulation}
\usage{
delaunay(points, atinfinity = FALSE, degenerate = FALSE, exteriorEdges = FALSE)
}
\arguments{
\item{points}{the points given as a matrix, one point per row}

\item{atinfinity}{Boolean, whether to include a point at infinity}

\item{degenerate}{Boolean, whether to include degenerate tiles}

\item{exteriorEdges}{Boolean, for dimension 3 only, whether to return
the exterior edges (see below)}
}
\value{
The Delaunay tessellation with many details, in a list. This list
  contains three fields:
\describe{
  \item{\emph{vertices}}{the vertices (or sites) of the tessellation; these
  are the points passed to the function}
  \item{\emph{tiles}}{the tiles of the tessellation (triangles in dimension 2,
  tetrahedra in dimension 3)}
  \item{\emph{tilefacets}}{the facets of the tiles of the tessellation}
}
In dimension 3, the list contains an additional field \emph{exteriorEdges}
  if you set \code{exteriorEdges = TRUE}. This is the list of the exterior
  edges, represented as \code{\link{Edge3}} objects. This field is involved
  in the function \code{\link{plotDelaunay3D}}.

The \strong{vertices} field is a list with the following fields:
\describe{
  \item{\emph{id}}{the id of the vertex; this is nothing but the index of
  the corresponding point passed to the function}
  \item{\emph{neighvertices}}{the ids of the vertices of the tessellation
  connected to this vertex by an edge}
  \item{\emph{neightilefacets}}{the ids of the tile facets this vertex
  belongs to}
  \item{\emph{neightiles}}{the ids of the tiles this vertex belongs to}
}
The \strong{tiles} field is a list with the following fields:
\describe{
  \item{\emph{id}}{the id of the tile}
  \item{\emph{simplex}}{a list describing the simplex (that is, the tile);
  this list contains four fields: \emph{vertices}, a
  \code{\link[hash]{hash}} giving the simplex vertices and their id,
  \emph{circumcenter}, the circumcenter of the simplex, \emph{circumradius},
  the circumradius of the simplex, and \emph{volume}, the volume of the
  simplex}
  \item{\emph{facets}}{the ids of the facets of this tile}
  \item{\emph{neighbors}}{the ids of the tiles adjacent to this tile}
  \item{\emph{family}}{two tiles have the same family if they share the
  same circumcenter; in this case the family is an integer, and the family is
  \code{NA} for tiles which do not share their circumcenter with any other
  tile}
  \item{\emph{orientation}}{\code{1} or \code{-1}, an indicator of the
  orientation of the tile}
}
The \strong{tilefacets} field is a list with the following fields:
\describe{
  \item{\emph{id}}{the id of this tile facet}
  \item{\emph{subsimplex}}{a list describing the subsimplex (that is, the
  tile facet); this list is similar to the \emph{simplex} list of
  \strong{tiles}}
  \item{\emph{facetOf}}{one or two ids, the id(s) of the tile this facet
  belongs to}
  \item{\emph{normal}}{a vector, the normal of the tile facet}
  \item{\emph{offset}}{a number, the offset of the tile facet}
}
}
\description{
Delaunay triangulation (or tessellation) of a set of points.
}
\examples{
library(tessellation)
points <- rbind(
 c(0.5,0.5,0.5),
 c(0,0,0),
 c(0,0,1),
 c(0,1,0),
 c(0,1,1),
 c(1,0,0),
 c(1,0,1),
 c(1,1,0),
 c(1,1,1)
)
del <- delaunay(points)
del$vertices[[1]]
del$tiles[[1]]
del$tilefacets[[1]]
}
\seealso{
\code{\link{getDelaunaySimplicies}}
}
