% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_data.R
\name{explicit_na}
\alias{explicit_na}
\title{Missing data}
\usage{
explicit_na(x, label = "<Missing>")
}
\arguments{
\item{x}{(\code{factor} or \code{character})\cr values for which any missing values should be substituted.}

\item{label}{(\code{string})\cr string that missing data should be replaced with.}
}
\value{
\code{x} with any \code{NA} values substituted by \code{label}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Substitute missing data with a string or factor level.
}
\examples{
explicit_na(c(NA, "a", "b"))
is.na(explicit_na(c(NA, "a", "b")))

explicit_na(factor(c(NA, "a", "b")))
is.na(explicit_na(factor(c(NA, "a", "b"))))

explicit_na(sas_na(c("a", "")))

}
