% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npars.R
\name{npars.term}
\alias{npars.term}
\title{Number of Parameters}
\usage{
\method{npars}{term}(x, scalar = NULL, ...)
}
\arguments{
\item{x}{An object.}

\item{scalar}{A flag specifying whether to by default return all parameters (NULL), or only scalar parameters (TRUE) or only non-scalar parameters (FALSE).}

\item{...}{Other arguments passed to methods.}
}
\value{
An integer scalar of the number of parameters.
}
\description{
Gets the number of parameters of an object.

The default methods returns the length of \code{\link[universals:pars]{pars()}} if none are
\code{NA}, otherwise it returns \code{NA}.
}
\examples{
npars(term("sigma", "alpha[1]", "alpha[2]", "beta[1,1]", "beta[2,1]"))
}
\seealso{
\code{\link[universals:pars]{pars()}}

Other MCMC dimensions: 
\code{\link[universals]{nchains}()},
\code{\link[universals]{niters}()},
\code{\link[universals]{nsams}()},
\code{\link[universals]{nsims}()},
\code{\link[universals]{nterms}()}

Other parameters: 
\code{\link[universals]{pars}()},
\code{\link[universals]{set_pars}()}
}
