% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.stergm.R
\name{simulate.network}
\alias{simulate.network}
\alias{simulate.stergm}
\alias{simulate.networkDynamic}
\title{STERGM wrappers for TERGM simulation}
\usage{
\method{simulate}{network}(
  object,
  nsim = 1,
  seed = NULL,
  formation,
  dissolution,
  coef.form,
  coef.diss,
  constraints = ~.,
  monitor = NULL,
  time.slices = 1,
  time.start = NULL,
  time.burnin = 0,
  time.interval = 1,
  time.offset = 1,
  control = control.simulate.network(),
  output = c("networkDynamic", "stats", "changes", "final", "ergm_state"),
  stats.form = FALSE,
  stats.diss = FALSE,
  verbose = FALSE,
  ...
)

\method{simulate}{networkDynamic}(
  object,
  nsim = 1,
  seed = NULL,
  formation,
  dissolution,
  coef.form = attr(object, "coef.form"),
  coef.diss = attr(object, "coef.diss"),
  constraints = ~.,
  monitor = NULL,
  time.slices = 1,
  time.start = NULL,
  time.burnin = 0,
  time.interval = 1,
  time.offset = 1,
  control = control.simulate.network(),
  output = c("networkDynamic", "stats", "changes", "final", "ergm_state"),
  stats.form = FALSE,
  stats.diss = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of type \code{\link{network}} or \code{\link{networkDynamic}}}

\item{nsim}{Number of replications (separate chains of networks) of the
process to run and return. The \code{\link{networkDynamic}} method only
supports \code{nsim=1}.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}.}

\item{formation, dissolution}{One-sided \code{\link{ergm}}-style formulas for
the formation and dissolution models, respectively.  The dissolution model is parameterized in terms of tie persistence.}

\item{coef.form}{Parameters for the formation model.}

\item{coef.diss}{Parameters for the dissolution (persistence) model.}

\item{constraints}{A formula specifying one or more constraints
on the support of the distribution of the networks being modeled. Multiple constraints
may be given, separated by \dQuote{+} and \dQuote{-} operators. See
\code{\link{ergmConstraint}} for the detailed explanation of
their semantics and also for an indexed list of the constraints visible to the \pkg{ergm} package.

The default is to have no constraints except those provided through
the \code{\link{ergmlhs}} API.

Together with the model terms in the formula and the reference measure, the constraints
define the distribution of networks being modeled.

It is also possible to specify a proposal function directly either
by passing a string with the function's name (in which case,
arguments to the proposal should be specified through the
\code{MCMC.prop.args} argument to the relevant control function, or
by giving it on the LHS of the hints formula to \code{MCMC.prop}
argument to the control function. This will override
the one chosen automatically.

Note that not all possible combinations of constraints and reference
measures are supported. However, for relatively simple constraints
(i.e., those that simply permit or forbid specific dyads or sets of
dyads from changing), arbitrary combinations should be possible.}

\item{monitor}{A one-sided formula specifying one or more terms whose
value is to be monitored.  If \code{monitor} is specified as a character
(one of \code{"formation"}, \code{"dissolution"}, and \code{"all"}) then
the function \code{\link{.extract.fd.formulae}} is used to determine the
corresponding formula; the user should be aware of its behavior and limitations.}

\item{time.slices}{Number of time slices (or statistics) to return from each
replication of the dynamic process. See below for return types. Defaults to
1, which, if \code{time.burnin==0} and \code{time.interval==1} (the
defaults), advances the process one time step.}

\item{time.start}{An optional argument specifying the time point at which
the simulation is to start. See Details for further information.}

\item{time.burnin}{Number of time steps to discard before starting to
collect network statistics.}

\item{time.interval}{Number of time steps between successive recordings of
network statistics.}

\item{time.offset}{Argument specifying the offset between the point when the
state of the network is sampled (\code{time.start}) and the the beginning of
the spell that should be recorded for the newly simulated network state.}

\item{control}{A list of control parameters for algorithm tuning,
constructed using \code{\link{control.simulate.network}}.  These are mapped
to \code{\link{control.simulate.formula.tergm}} controls by assigning:
\itemize{
\item \code{MCMC.prop.form} to \code{MCMC.prop},
\item \code{MCMC.prop.args.form} to \code{MCMC.prop.args}, and
\item \code{MCMC.prop.weights.form} to \code{MCMC.prop.weights}.
}}

\item{output}{A character vector specifying output type: one of
\code{"networkDynamic"} (the default), \code{"stats"}, \code{"changes"},
\code{"final"}, and \code{"ergm_state"}, with partial matching allowed.}

\item{stats.form, stats.diss}{Logical: Whether to return
formation/dissolution model statistics. This is not the recommended method:
use the \code{monitor} argument instead.  Note that if either \code{stats.form}
or \code{stats.diss} is \code{TRUE}, all generative model statistics will be
returned.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{\dots}{Further arguments passed to or used by methods.}
}
\value{
Depends on the \code{output} argument.  See \code{\link{simulate.tergm}}
for details.  Note that some formation/dissolution separated
information is also attached to the return value for calls made through
\code{simulate.network} and \code{simulate.networkDynamic} in
an attempt to increase backwards compatibility.
}
\description{
The \code{simulate.network} and \code{simulate.networkDynamic} wrappers
are provided for backwards compatibility.  It is recommended that new
code make use of the \code{simulate_formula.network} and
\code{simulate_formula.networkDynamic} functions instead.  See
\code{\link{simulate.tergm}} for details on these new functions.
}
\details{
Note that return values may be structured differently than in past versions.

Remember that in \code{stergm}, the dissolution formula is parameterized in
terms of tie persistence: negative coefficients imply lower rates of persistence
and postive coefficients imply higher rates.  The dissolution effects are simply the
negation of these coefficients.

Because the old \code{dissolution} formula in \code{stergm} represents
tie persistence, it maps to the new \code{Persist()} operator
in the \code{tergm} function, NOT the \code{Diss()} operator
}
\examples{
\donttest{
logit<-function(p)log(p/(1-p))
coef.form.f<-function(coef.diss,density) -log(((1+exp(coef.diss))/(density/(1-density)))-1)

# Construct a network with 20 nodes and 20 edges
n<-20
target.stats<-edges<-20
g0<-network.initialize(n,dir=TRUE)
g1<-san(g0~edges,target.stats=target.stats,verbose=TRUE)

S<-10

# To get an average duration of 10...
duration<-10
coef.diss<-logit(1-1/duration)

# To get an average of 20 edges...
dyads<-network.dyadcount(g1)
density<-edges/dyads
coef.form<-coef.form.f(coef.diss,density)

# ... coefficients.
print(coef.form)
print(coef.diss)

# Simulate a networkDynamic
dynsim<-simulate(g1,formation=~edges,dissolution=~edges,
                 coef.form=coef.form,coef.diss=coef.diss,
                 time.slices=S,verbose=TRUE)

# "Resume" the simulation.
dynsim2<-simulate(dynsim,formation=~edges,dissolution=~edges,time.slices=S,verbose=TRUE)
}
}
