% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseAlpha.R
\name{summariseAlpha}
\alias{summariseAlpha}
\title{Summarize alphas}
\usage{
summariseAlpha(alpha, prob = 0.95, coords.s, coords.r)
}
\arguments{
\item{alpha}{structure containing posterior inference for remote coefficients}

\item{prob}{confidence level for confidence intervals and significance}

\item{coords.s}{matrix with coordinates where responses were 
observed (lon, lat)}

\item{coords.r}{matrix with coordinates where remote covariates
were observed (lon, lat)}
}
\description{
This function computes approximate normal intervals, etc. for fitted alphas.
}
\examples{
\dontrun{
data("coprecip")
data("coprecip.fit")
attach(coprecip)

# sample posterior predictive distributions AND estimate teleconnection effects
coprecip.precict = stPredict(stFit = coprecip.fit, stData = coprecip, 
                             stDataNew = coprecip, burn = 90, 
                             returnFullAlphas = TRUE)

alpha.90 = summariseAlpha(alpha = coprecip.precict$alpha, prob = .9, 
                          coords.s = coords.s, coords.r = coords.r)
}
}
