% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{euler_pole}
\alias{euler_pole}
\title{Euler pole object}
\usage{
euler_pole(x, y, z = NA, geo = TRUE, angle = NA)
}
\arguments{
\item{x}{latitude or x coordinate of Euler pole axis}

\item{y}{longitude or y}

\item{z}{z coordinate}

\item{geo}{logical, \code{TRUE} (the default) if Euler pole axis is given in
geographical coordinates (latitude, longitude). \code{FALSE} if given in
Cartesian coordinates (\code{x}, \code{y}, \code{z})}

\item{angle}{(optional) Angle of rotation in degrees (CCW rotation if angle
is positive)}
}
\value{
An object of class \code{"euler.pole"} containing the Euler pole
axis in both geographical and Cartesian coordinates and the angle of rotation
in radians.
}
\description{
Creates an object of the orientation of the Euler pole axis
}
\examples{
euler_pole(90, 0, angle = 45)
euler_pole(0, 0, 1, geo = FALSE)
}
