% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimpleReporter.R
\name{simple_reporter}
\alias{simple_reporter}
\alias{simple_reporter_ui}
\alias{simple_reporter_srv}
\title{Simple reporter module}
\usage{
simple_reporter_ui(id)

simple_reporter_srv(
  id,
  reporter,
  card_fun,
  global_knitr = getOption("teal.reporter.global_knitr"),
  rmd_output = c(html = "html_document", pdf = "pdf_document", powerpoint =
    "powerpoint_presentation", word = "word_document"),
  rmd_yaml_args = list(author = "NEST", title = "Report", date =
    as.character(Sys.Date()), output = "html_document", toc = FALSE)
)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{reporter}{(\code{Reporter}) instance.}

\item{card_fun}{(\code{function}) which returns a \code{\link{ReportCard}} instance,
the function has a \code{card} argument and an optional \code{comment} argument.}

\item{global_knitr}{(\code{list}) a global \code{knitr} parameters for customizing the rendering process.}

\item{rmd_output}{(\code{character}) vector with \code{rmarkdown} output types,
by default all possible \code{pdf_document}, \code{html_document}, \code{powerpoint_presentation}, and \code{word_document}.
If vector is named then those names will appear in the \code{UI}.}

\item{rmd_yaml_args}{(\verb{named list}) with \code{Rmd} \code{yaml} header fields and their default values.
This \code{list} will result in the custom subset of UI inputs for the download reporter functionality.
Default \code{list(author = "NEST", title = "Report", date = Sys.Date(), output = "html_document", toc = FALSE)}.
The \code{list} must include at least \code{"output"} field.
The default value for \code{"output"} has to be in the \code{rmd_output} argument.}
}
\value{
\code{NULL}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Module provides compact UI and server functions for managing a report in a \code{shiny} app.
This module combines functionalities for \link[=add_card_button]{adding cards to a report},
\link[=download_report_button]{downloading the report}, and \link[=reset_report_button]{resetting report content}.

For more details see the vignette: \code{vignette("simpleReporter", "teal.reporter")}.
}
\details{
To access the default values for the \code{global_knitr} parameter,
use \code{getOption('teal.reporter.global_knitr')}. These defaults include:
\itemize{
\item \code{echo = TRUE}
\item \code{tidy.opts = list(width.cutoff = 60)}
\item \code{tidy = TRUE}  if \code{formatR} package is installed, \code{FALSE} otherwise
}
}
\examples{
library(shiny)
if (interactive()) {
  shinyApp(
    ui = fluidPage(simple_reporter_ui("simple")),
    server = function(input, output, session) {
      simple_reporter_srv("simple", Reporter$new(), function(card) card)
    }
  )
}
}
