% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimpleReporter.R
\name{simple_reporter_srv}
\alias{simple_reporter_srv}
\title{Simple Reporter Server}
\usage{
simple_reporter_srv(
  id,
  reporter,
  card_fun,
  global_knitr = getOption("teal.reporter.global_knitr"),
  rmd_output = c(html = "html_document", pdf = "pdf_document", powerpoint =
    "powerpoint_presentation", word = "word_document"),
  rmd_yaml_args = list(author = "NEST", title = "Report", date =
    as.character(Sys.Date()), output = "html_document", toc = FALSE)
)
}
\arguments{
\item{id}{\code{character(1)} this \code{shiny} module's id.}

\item{reporter}{\code{\link{Reporter}} instance.}

\item{card_fun}{\code{function} which returns a \code{\link{ReportCard}} instance,
the function has a \code{card} argument and an optional \code{comment} argument.}

\item{global_knitr}{\code{list} a global \code{knitr} parameters for customizing the rendering process.}

\item{rmd_output}{\code{character} vector with \code{rmarkdown} output types,
by default all possible \code{c("pdf_document", "html_document", "powerpoint_presentation", "word_document")}.
If vector is named then those names will appear in the \code{UI}.}

\item{rmd_yaml_args}{\verb{named list} with \code{Rmd} \code{yaml} header fields and their default values.
This \code{list} will result in the custom subset of User Interface inputs for the download reporter functionality.
Default \code{list(author = "NEST", title = "Report", date = Sys.Date(), output = "html_document", toc = FALSE)}.
The \code{list} must include at least \code{"output"} field.
The default value for \code{"output"} has to be in the \code{rmd_output} argument.}
}
\value{
\code{shiny::moduleServer}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
three buttons for adding cards, downloading and resetting the Report.
The add module has \code{add_report_card_simple} id, the download module the \code{download_button_simple} id
and the reset module the \code{reset_button_simple} id.

For more details see the vignette: \code{vignette("simpleReporter", "teal.reporter")}.
}
\details{
To access the default values for the \code{global_knitr} parameter,
use \code{getOption('teal.reporter.global_knitr')}. These defaults include:
\itemize{
\item \code{echo = TRUE}
\item \code{tidy.opts = list(width.cutoff = 60)}
\item \code{tidy = TRUE}  if \code{formatR} package is installed, \code{FALSE} otherwise
}
}
