% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reporter.R
\name{Reporter}
\alias{Reporter}
\title{\code{Reporter}}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
R6 class that stores and manages report cards.
}
\note{
The function has to be used in the shiny reactive context.
}
\examples{

## ------------------------------------------------
## Method `Reporter$new`
## ------------------------------------------------

reporter <- teal.reporter::Reporter$new()


## ------------------------------------------------
## Method `Reporter$append_cards`
## ------------------------------------------------

card1 <- teal.reporter::ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)

card2 <- teal.reporter::ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text", "header2")
lyt <- rtables::analyze(rtables::split_rows_by(rtables::basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- rtables::build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_table(iris)

reporter <- teal.reporter::Reporter$new()
reporter$append_cards(list(card1, card2))


## ------------------------------------------------
## Method `Reporter$get_cards`
## ------------------------------------------------

card1 <- teal.reporter::ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)

card2 <- teal.reporter::ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text", "header2")
lyt <- rtables::analyze(rtables::split_rows_by(rtables::basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- rtables::build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_table(iris)

reporter <- teal.reporter::Reporter$new()
reporter$append_cards(list(card1, card2))
reporter$get_cards()

## ------------------------------------------------
## Method `Reporter$get_blocks`
## ------------------------------------------------

card1 <- teal.reporter::ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)

card2 <- teal.reporter::ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text", "header2")
lyt <- rtables::analyze(rtables::split_rows_by(rtables::basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- rtables::build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_table(iris)

reporter <- teal.reporter::Reporter$new()
reporter$append_cards(list(card1, card2))
reporter$get_blocks()


## ------------------------------------------------
## Method `Reporter$get_reactive_add_card`
## ------------------------------------------------

shiny::isolate(Reporter$new()$get_reactive_add_card())

## ------------------------------------------------
## Method `Reporter$get_metadata`
## ------------------------------------------------

reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()


## ------------------------------------------------
## Method `Reporter$append_metadata`
## ------------------------------------------------

reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()


## ------------------------------------------------
## Method `Reporter$from_reporter`
## ------------------------------------------------

reporter <- Reporter$new()
reporter$from_reporter(reporter)

## ------------------------------------------------
## Method `Reporter$to_list`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
dir.create(tmp_dir)
reporter$to_list(tmp_dir)

## ------------------------------------------------
## Method `Reporter$from_list`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
unlink(tmp_dir, recursive = TRUE)
dir.create(tmp_dir)
reporter$from_list(reporter$to_list(tmp_dir), tmp_dir)

## ------------------------------------------------
## Method `Reporter$to_jsondir`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
reporter$to_jsondir(tmp_dir)

## ------------------------------------------------
## Method `Reporter$from_jsondir`
## ------------------------------------------------

reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
unlink(list.files(tmp_dir, recursive = TRUE))
reporter$to_jsondir(tmp_dir)
reporter$from_jsondir(tmp_dir)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Reporter-new}{\code{Reporter$new()}}
\item \href{#method-Reporter-append_cards}{\code{Reporter$append_cards()}}
\item \href{#method-Reporter-get_cards}{\code{Reporter$get_cards()}}
\item \href{#method-Reporter-get_blocks}{\code{Reporter$get_blocks()}}
\item \href{#method-Reporter-reset}{\code{Reporter$reset()}}
\item \href{#method-Reporter-remove_cards}{\code{Reporter$remove_cards()}}
\item \href{#method-Reporter-swap_cards}{\code{Reporter$swap_cards()}}
\item \href{#method-Reporter-get_reactive_add_card}{\code{Reporter$get_reactive_add_card()}}
\item \href{#method-Reporter-get_metadata}{\code{Reporter$get_metadata()}}
\item \href{#method-Reporter-append_metadata}{\code{Reporter$append_metadata()}}
\item \href{#method-Reporter-from_reporter}{\code{Reporter$from_reporter()}}
\item \href{#method-Reporter-to_list}{\code{Reporter$to_list()}}
\item \href{#method-Reporter-from_list}{\code{Reporter$from_list()}}
\item \href{#method-Reporter-to_jsondir}{\code{Reporter$to_jsondir()}}
\item \href{#method-Reporter-from_jsondir}{\code{Reporter$from_jsondir()}}
\item \href{#method-Reporter-clone}{\code{Reporter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-new"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-new}{}}}
\subsection{Method \code{new()}}{
Returns a \code{Reporter} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \code{Reporter} object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- teal.reporter::Reporter$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-append_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-append_cards}{}}}
\subsection{Method \code{append_cards()}}{
Appends a table to this \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$append_cards(cards)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cards}}{\code{\link{ReportCard}} or a list of such objects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card1 <- teal.reporter::ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)

card2 <- teal.reporter::ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text", "header2")
lyt <- rtables::analyze(rtables::split_rows_by(rtables::basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- rtables::build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_table(iris)

reporter <- teal.reporter::Reporter$new()
reporter$append_cards(list(card1, card2))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_cards}{}}}
\subsection{Method \code{get_cards()}}{
Returns cards of this \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_cards()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list()} list of \code{\link{ReportCard}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card1 <- teal.reporter::ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)

card2 <- teal.reporter::ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text", "header2")
lyt <- rtables::analyze(rtables::split_rows_by(rtables::basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- rtables::build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_table(iris)

reporter <- teal.reporter::Reporter$new()
reporter$append_cards(list(card1, card2))
reporter$get_cards()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_blocks"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_blocks}{}}}
\subsection{Method \code{get_blocks()}}{
Returns blocks of all \code{\link{ReportCard}} of this \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_blocks(sep = NewpageBlock$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sep}}{the element inserted between each content element in this \code{Reporter}.
Pass \code{NULL} to return content without any additional elements. Default: \code{NewpageBlock$new()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{list()} list of \code{TableBlock}, \code{TextBlock}, \code{PictureBlock} and \code{NewpageBlock}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card1 <- teal.reporter::ReportCard$new()

card1$append_text("Header 2 text", "header2")
card1$append_text("A paragraph of default text", "header2")
card1$append_plot(
 ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)

card2 <- teal.reporter::ReportCard$new()

card2$append_text("Header 2 text", "header2")
card2$append_text("A paragraph of default text", "header2")
lyt <- rtables::analyze(rtables::split_rows_by(rtables::basic_table(), "Day"), "Ozone", afun = mean)
table_res2 <- rtables::build_table(lyt, airquality)
card2$append_table(table_res2)
card2$append_table(iris)

reporter <- teal.reporter::Reporter$new()
reporter$append_cards(list(card1, card2))
reporter$get_blocks()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-reset}{}}}
\subsection{Method \code{reset()}}{
Removes all \code{\link{ReportCard}} objects added to this \code{Reporter}.
Additionally all metadata are removed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisibly self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-remove_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-remove_cards}{}}}
\subsection{Method \code{remove_cards()}}{
remove a specific Card in the Reporter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$remove_cards(ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{\code{integer} the indexes of cards}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-swap_cards"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-swap_cards}{}}}
\subsection{Method \code{swap_cards()}}{
swap two cards in the Reporter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$swap_cards(start, end)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start}}{\code{integer} the index of the first card}

\item{\code{end}}{\code{integer} the index of the second card}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_reactive_add_card"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_reactive_add_card}{}}}
\subsection{Method \code{get_reactive_add_card()}}{
get a value for the reactive value for the add card
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_reactive_add_card()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{reactive_add_card} field value
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{shiny::isolate(Reporter$new()$get_reactive_add_card())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
get metadata of this \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$get_metadata()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
metadata
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-append_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-append_metadata}{}}}
\subsection{Method \code{append_metadata()}}{
Appends metadata to this \code{Reporter}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$append_metadata(meta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{meta}}{(\code{list}) of metadata.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()$append_metadata(list(sth = "sth"))
reporter$get_metadata()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-from_reporter"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-from_reporter}{}}}
\subsection{Method \code{from_reporter()}}{
Create/Recreate a Reporter from another Reporter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$from_reporter(reporter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reporter}}{\code{Reporter} instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
reporter$from_reporter(reporter)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert a Reporter to a list and transfer files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$to_list(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{\code{character(1)} a path to the directory where files will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{named list} \code{Reporter} representation
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
dir.create(tmp_dir)
reporter$to_list(tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-from_list}{}}}
\subsection{Method \code{from_list()}}{
Create/Recreate a Reporter from a list and directory with files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$from_list(rlist, output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rlist}}{\verb{named list} \code{Reporter} representation.}

\item{\code{output_dir}}{\code{character(1)} a path to the directory from which files will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "testdir")
unlink(tmp_dir, recursive = TRUE)
dir.create(tmp_dir)
reporter$from_list(reporter$to_list(tmp_dir), tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-to_jsondir"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-to_jsondir}{}}}
\subsection{Method \code{to_jsondir()}}{
Create/Recreate a Reporter to a directory with \code{JSON} file and static files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$to_jsondir(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{\code{character(1)} a path to the directory where files will be copied, \code{JSON} and statics.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
reporter$to_jsondir(tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-from_jsondir"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-from_jsondir}{}}}
\subsection{Method \code{from_jsondir()}}{
Create/Recreate a Reporter from a directory with \code{JSON} file and static files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$from_jsondir(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{\code{character(1)} a path to the directory with files, \code{JSON} and statics.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{reporter <- Reporter$new()
tmp_dir <- file.path(tempdir(), "jsondir")
dir.create(tmp_dir)
unlink(list.files(tmp_dir, recursive = TRUE))
reporter$to_jsondir(tmp_dir)
reporter$from_jsondir(tmp_dir)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Reporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
