% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_smq.R
\name{tm_t_smq}
\alias{tm_t_smq}
\title{teal Module: Adverse Events Table by Standardized MedDRA Query}
\usage{
tm_t_smq(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  id_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    subset = "USUBJID"), selected = "USUBJID", fixed = TRUE),
  llt,
  add_total = TRUE,
  total_label = default_total_label(),
  sort_criteria = c("freq_desc", "alpha"),
  drop_arm_levels = TRUE,
  na_level = default_na_str(),
  smq_varlabel = "Standardized MedDRA Query",
  baskets,
  scopes,
  pre_output = NULL,
  post_output = NULL,
  basic_table_args = teal.widgets::basic_table_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable(s) in the results table.
If there are two elements selected for \code{arm_var},
second variable will be nested under the first variable.}

\item{id_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object specifying
the variable name for subject id.}

\item{llt}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr name of the variable
with low level term for events.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{sort_criteria}{(\code{character})\cr how to sort the final table. Default option \code{freq_desc} sorts
on column \code{sort_freq_col} by decreasing number of patients with event. Alternative option \code{alpha} sorts events
alphabetically.}

\item{drop_arm_levels}{(\code{logical})\cr whether to drop unused levels of \code{arm_var}. If \code{TRUE}, \code{arm_var} levels are
set to those used in the \code{dataname} dataset. If \code{FALSE}, \code{arm_var} levels are set to those used in the
\code{parentname} dataset. If \code{dataname} and \code{parentname} are the same, then \code{drop_arm_levels} is set to \code{TRUE} and
user input for this parameter is ignored.}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{smq_varlabel}{(\code{character})\cr label to use for new column \code{SMQ} created by \code{\link[tern:h_stack_by_baskets]{tern::h_stack_by_baskets()}}.}

\item{baskets}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected options for standardized/customized queries.}

\item{scopes}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices for the scopes of standardized queries.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces an adverse events table by Standardized MedDRA Query.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{table} (\code{TableTree} - output of \code{rtables::build_table()})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_t_smq(
   ..., # arguments for module
   decorators = list(
     table = teal_transform_module(...) # applied only to `table` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
data <- teal_data()
data <- within(data, {
  ADSL <- tmc_ex_adsl
  ADAE <- tmc_ex_adae

  .names_baskets <- grep("^(SMQ|CQ).*NAM$", names(ADAE), value = TRUE)
  .names_scopes <- grep("^SMQ.*SC$", names(ADAE), value = TRUE)

  .cs_baskets <- choices_selected(
    choices = variable_choices(ADAE, subset = .names_baskets),
    selected = .names_baskets
  )

  .cs_scopes <- choices_selected(
    choices = variable_choices(ADAE, subset = .names_scopes),
    selected = .names_scopes,
    fixed = TRUE
  )
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

app <- init(
  data = data,
  modules = modules(
    tm_t_smq(
      label = "Adverse Events by SMQ Table",
      dataname = "ADAE",
      arm_var = choices_selected(
        choices = variable_choices(data[["ADSL"]], subset = c("ARM", "SEX")),
        selected = "ARM"
      ),
      add_total = FALSE,
      baskets = data[[".cs_baskets"]],
      scopes = data[[".cs_scopes"]],
      llt = choices_selected(
        choices = variable_choices(data[["ADAE"]], subset = c("AEDECOD")),
        selected = "AEDECOD"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpfyiko+o12oB9d09rNw8vQx0Ad1pSAAtaCHZAqFwdECUdHQBBABEAZQAZbx1SGAI-OAAPPyh+UWp0rOzMpyKSssrq9zhXCAyMaHhRP3ooUQBrOFJRIoBzRjhUdgUwAD12XIBZAEUAHwBhLbkMACoAOUyNgBJllIGxdhzmuRTNbkFdAF47RydFXp1+rAxH5RMRUGJZvNFssVpstidcntrngdHdRA8mr8Xm9Pt9nH8GhIhiNxpNpuECDEiDJgaI4CJ1HB+Et-hlKdSCBCvq9GLQoPQRH52TT0Y8nClRIJ6HTSDovoDBsNRhMps8Ghk6QzyPw5QC0UrSVMGgT-kSQWCIRSqSKQfS4IzmeqdMLOdNuSw+QK4ELra6Mc0JVKZbqFbSLaI1aydJr7dqQ-rQURwaJcE7jLQKkzdfZnMalABfP4AK2pED8E1Y6KSNnC-DgxigwlIQv4tFBfhL8XLcErwDRiVCcgAuj00KgivFoiyMkldUlU-8+EIRG6dEvhPcnSU-M3RDAAI7TjLH6j8+m65aZfjaRh0nRObRkab0Vg6OF2fkiG5OmehO4XsAxW-KMMhYGA-B5XUXVpO0HSPY9j2g1ceU9QUkIHTxgGAS88nyZYhyHQNpUmKClkArANhuHRllyJwAA1ljkSMEIQmMHQAzIKOWH8dGYlian4HciE8ahdQAMUyfJaIXFidBJFVVySLDljNeSyXwwieMTZM51CZSwDNbSxA0mSWOoahZS+JDbS1Jl4JYpDdRQz9vXQpTsMAzETOjIMSKssjmmyJw9gAeWyRi+Nkti4y+S8nCC0LwrAHi-gQ1LeKUP5aGMHR2Hicg1A0bRrBsNJ-lEOIIFYTJ0HYMdLkEWgUnqulGBvP58yUMB8yHIA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpfyiko+o12oB9d09rNw8vQx0Ad1pSAAtaCHZAqFwdECUdHQBBABEAZQAZbx1SGAI-OAAPPyh+UWp0rOzMpyKSssrq9zhXCAyMaHhRP3ooUQBrOFJRIoBzRjhUdgUwAD12XIBZAEUAHwBhLbkMACoAOUyNgBJllIGxdhzmuRTNbkFdAF47RydFXp1+rAxH5RMRUGJZvNFssVpstidcntrngdHdRA8mr8Xm9Pt9nH8GhIhiNxpNpuECDEiDJgaI4CJ1HB+Et-hlKdSCBCvq9GLQoPQRH52TT0Y8nClRIJ6HTSDovoDBsNRhMps8Ghk6QzyPw5QC0UrSVMGgT-kSQWCIRSqSKQfS4IzmeqdMLOdNuSw+QK4ELra6Mc0JVKZbqFbSLaI1aydJr7dqQ-rQURwaJcE7jLQKkzdfZnMalABfP4AK2pED8E1Y6KSNnC-DgxigwlIQv4tFBfhL8XLcErwDRiVCcgAuj00KgivFoiyMkldUlU-8+EIRG6dEvhPcnSU-M3RDAAI7TjLH6j8+m65aZfjaRh0nRObRkab0Vg6OF2fkiG5OmehO4XsAxW-KMMhYGA-B5XUXVpO0HSPY9j2g1ceU9QUkIHTxgGAS88nyZYhyHQNpUmKClkArANhuHRllyJwAA1ljkSMEIQmMHQAzIKOWH8dGYlian4HciE8ahdQAMUyfJaIXFidBJFVVySLDljNeSyXwwieMTZM51CZSwDNbSxA0mSWOoahZS+JDbS1Jl4JYpDdRQz9vXQpTsMAzETOjIMSKssjmmyJw9gAeWyRi+Nkti4y+S8nCC0LwrAHi-gQ1LeKUP5aGMHR2Hicg1A0bRrBsNJ-lEOIIFYTJ0HYMdLkEWgUnqulGBvP58yUMB8yHIA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

