% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-constructor.R
\name{new_qenv}
\alias{new_qenv}
\alias{new_qenv,environment,expression-method}
\alias{new_qenv,environment,character-method}
\alias{new_qenv,environment,language-method}
\alias{new_qenv,missing,missing-method}
\title{Initialize \code{qenv} object}
\usage{
new_qenv(env = new.env(parent = parent.env(.GlobalEnv)), code = expression())

\S4method{new_qenv}{environment,expression}(env = new.env(parent = parent.env(.GlobalEnv)), code = expression())

\S4method{new_qenv}{environment,character}(env = new.env(parent = parent.env(.GlobalEnv)), code = expression())

\S4method{new_qenv}{environment,language}(env = new.env(parent = parent.env(.GlobalEnv)), code = expression())

\S4method{new_qenv}{missing,missing}(env = new.env(parent = parent.env(.GlobalEnv)), code = expression())
}
\arguments{
\item{env}{(\code{environment}) Environment being a result of the \code{code} evaluation.}

\item{code}{(\code{character(1)} or \code{language}) code to evaluate. Accepts and stores comments also.}
}
\value{
\code{qenv} object.
}
\description{
Initialize \code{qenv} object with \code{code} and \code{env}. In order to have \code{qenv} reproducible
one needs to initialize with \code{env} which can be reproduced by the \code{code}. Alternatively, one
can create an empty \code{qenv} and evaluate the expressions in this object using \code{eval_code}.
}
\examples{
new_qenv(env = list2env(list(a = 1)), code = quote(a <- 1))
new_qenv(env = list2env(list(a = 1)), code = parse(text = "a <- 1"))
new_qenv(env = list2env(list(a = 1)), code = "a <- 1")

}
