# output file of Digoxin including multiple subjects information and predict PK parameters obtained from each single concentration
Digms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Digoxin_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------\n")
     cat("    --Digoxin input data information--          \n")
     cat("    Gender = Male=1 ; Female=0                  \n")
     cat("    age = age(yr)                               \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    scr = serum creatinine conc.(mg/dL)         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    c = measured steady-state conc.(ng/mL)      \n")
     cat("------------------------------------------------\n")         
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
     cat("----------------------------------------------------------\n")
     cat("  --Digoxin output data information--                     \n")
     cat("  cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("  Cmss_pr = predicted steady-state measured conc. (ng/mL) \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Carbamazepine including multiple subjects information and predict PK parameters obtained from each single concentration
Carms.pkoutput<-function(B,F,G){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Carbamazepine_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-----------------------------------------------------------\n")
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Y=1;N=0)                       \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("    ts = sampling time(hr)                                 \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("-----------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
list("Cmss_pr:\n")
show(F[i,])
list("Ctss_pr:\n")
show(G[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Carbamazepine output data information--              \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}


# output file of Aminoglycoside including multiple subjects information and predict PK parameters obtained from each single concentration
Amims.pkoutput<-function(B,F,G,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Aminoglycoside_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("----------------------------------------------------\n")
     cat("    --Aminoglycoside input data information--       \n")
     cat("    Gender = Male=1 ; Female=0                      \n")
     cat("    age = age(yr)                                   \n")
     cat("    bw = body weight(kg)                            \n")
     cat("    Ht = height(cm)                                 \n")
     cat("    Scr = serum creatinine conc.(mg/dL)             \n")
     cat("    D = dose for each dosing interval(mg)           \n")
     cat("    tau = dosing interval(hr)                       \n")
     cat("    tin = infusion time(hr)                         \n")
     cat("    ts = sampling time since infusion end (hr)      \n")
     cat("    c = measured steady-state conc.(mg/L)           \n") 
     cat("----------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl")[i,])
cat("\n")
show(samplesStats("v")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Cpss_pr:")
show(G[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Aminoglycoside output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}


# output file of Pediatric Digoxin including multiple subjects information and predict PK parameters obtained from each single concentration
PedDigms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Pediatric Digoxin_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------------\n")
     cat("    --Pediatric Digoxin input data information--      \n")
     cat("    age = age (month)                                 \n") 
     cat("    bw = body weight(kg)                              \n")
     cat("    D = dose for each dosing interval(mcg)            \n")  
     cat("    tau = dosing interval(hr)                         \n")
     cat("    c = measured steady-state conc.(mcg/L)            \n")
     cat("------------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
     cat("------------------------------------------------------------\n")
     cat("    --Pediatric Digoxin output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr/kg)                  \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")     
     cat("------------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}




# output file of Lithium corbonate including multiple subjects information and predict PK parameters obtained from each single concentration
Litms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Lithium carbonate_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("---------------------------------------------------------\n")
     cat("    --Lithium carbonate input data information--         \n")
     cat("    age = age (yr)                                       \n") 
     cat("    f = age<50 (Y=0,N=1)                                 \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    Scr = serum creatinine conc (mg/dL)                  \n")   
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mEq/L)               \n")    
     cat("---------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Lithium carbonate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Lithium citrate including multiple subjects information and predict PK parameters obtained from each single concentration
Litcitms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Lithium citrate_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("----------------------------------------------------\n")
     cat("    --Lithium citrate input data information--      \n")
     cat("    age = age (yr)                                  \n") 
     cat("    f = age<50 (Y=0,N=1)                            \n") 
     cat("    bw = body weight(kg)                            \n")
     cat("    Scr = serum creatinine conc (mg/dL)             \n")   
     cat("    D = dose for each dosing interval(mg)           \n")
     cat("    tau = dosing interval(hr)                       \n")
     cat("    c = measured steady-state conc.(mEq/L)          \n")    
     cat("----------------------------------------------------\n")      
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Lithium citrate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of phenytoin including multiple subjects information and predict PK parameters obtained from each single concentration
Phems.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Phenytoin_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-----------------------------------------------\n")
     cat("    --Phenytoin input data information--       \n")
     cat("    bw = body weight(kg)                       \n")
     cat("    D = dose for each dosing interval(mg)      \n")
     cat("    tau = dosing interval(hr)                  \n")
     cat("    c = measured steady-state conc.(mg/L)      \n")
     cat("-----------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("Vmax")[i,])
cat("\n")
show(samplesStats("Km")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Phenytoin output data information--                 \n")
     cat("    Vamx = maximum rate of metabolism (mg/day)            \n")
     cat("    Km = plasm concentration at which metabolidm is       \n")
     cat("         occuring at half the maximum rate (mg/L)         \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of children valproate including multiple subjects information and predict PK parameters obtained from each single concentration
ChiValms.pkoutput<-function(B,F,G){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << children Valproate_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------------\n")
     cat("    --Children Valpraote input data information--     \n")
     cat("    TBW = total body weight (Kg)                      \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)            \n")
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n") 
     cat("    c = measured steady-state conc.(mg/L)             \n")  
     cat("------------------------------------------------------\n")      
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(G[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Children Valpraote output data information--        \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Valproate including multiple subjects information and predict PK parameters obtained from each single concentration
Valms.pkoutput<-function(B,F,G){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Valproate_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-------------------------------------------------------------\n")
     cat("   --Valpraote input data information--                      \n")
     cat("   age = age (yr)                                            \n")   
     cat("   INDI(indication)=1 for uncontrolled epilepsy, otherwise 0 \n")
     cat("   CBZ = combine CArbamazepine (Y=1, N=0)                    \n")
     cat("   ka = 4 for oral solution, 1 for enteric tablet            \n")
     cat("   D = dose for each dosing interval(mg)                     \n") 
     cat("   tau = dosing interval(hr)                                 \n")
     cat("   ts = sampling time (hr)                                   \n") 
     cat("   c = measured steady-state conc.(mg/L)                     \n")  
     cat("-------------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(G[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Valpraote output data information--                 \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")

cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of vancomycin including multiple subjects information and predict PK parameters obtained from each single concentration
Vanms.pkoutput<-function(B,F,G,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Vancomycin_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("---------------------------------------------------\n")
     cat("    --Vancomycin input data information--          \n")
     cat("    Gender = 1 for Male ; 0 for Female             \n")
     cat("    age = age(yr)                                  \n")
     cat("    bw = body weight (kg)                          \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)            \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    tin = infusion time(hr)                        \n") 
     cat("    ts = sampling time since infusion end (hr)     \n") 
     cat("    c = measured steady-state conc.(mg/L)          \n")
     cat("---------------------------------------------------\n")    
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl")[i,])
cat("\n")
show(samplesStats("v")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Cpss_pr:")
show(G[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Vancomycin output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Enfuvirtide including multiple subjects information and predict PK parameters obtained from each single concentration
Enfms.pkoutput<-function(B,F,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Enfuvirtide_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------\n")
     cat("    --Enfuvirtide input data information--      \n")
     cat("    Gender : 1 for Male ; 0 for Female          \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mg/L)       \n")
     cat("------------------------------------------------\n")  
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                                    
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
show(samplesStats("ka")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Enfuvirtide output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr)  \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}


# output file of Indinavir including multiple subjects information and predict PK parameters obtained from each single concentration
Indms.pkoutput<-function(B,F,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Indinavir_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-----------------------------------------------\n")
     cat("    --Indinavir input data information--       \n")
     cat("    Gender = 1 for Male ; 0 for Female         \n")
     cat("    bw = body weight(kg)                       \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)      \n")
     cat("    tau = dosing interval(hr)                  \n")
     cat("    ts = sampling time(hr)                     \n")
     cat("    c = measured steady-state conc.(mg/L)      \n")    
     cat("-----------------------------------------------\n")   
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])   
cat("\n")
show(samplesStats("ka")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
      cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}




# output file of Ritonavir including multiple subjects information and predict PK parameters obtained from each single concentration
Ritms.pkoutput<-function(B,F,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Ritonavir_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------\n")
     cat("    --Ritonavir input data information--        \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-stat conc.(mg/L)        \n")    
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Ritonavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of cyclosporine including multiple subjects information and predict PK parameters obtained from each single concentration
Cycms.pkoutput<-function(B,F,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Cyclosporine_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("---------------------------------------------------\n")
     cat("    --Cyclosporine input data information--        \n")
     cat("    bw = body weight(kg)                           \n")
     cat("    PTD = post-transplant day(day)                 \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)               \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    ts = sampling time(hr)                         \n")
     cat("    c = measured steady-state conc.(mcg/L)         \n")
     cat("---------------------------------------------------\n")    
cat("\n\n")                            
cat("<< PK parameters >>       \n")
cat("\n")
show(samplesStats("cl")[i,])                                 
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
     cat("   --Cyclosporine output data information--               \n")
     cat("   cl = clerance (L/hr)                   \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Everolimus including multiple subjects information and predict PK parameters obtained from each single concentration
Evems.pkoutput<-function(B,F,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Everolimus_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------\n")
     cat("    --Everolimus input data information--       \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    age = age(yr)                               \n")
     cat("    race = 1 for black ; otherwise 0            \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mcg/L)      \n")  
     cat("------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Everolimus output data information--                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Tacrolimus including multiple subjects information and predict PK parameters obtained from each single concentration
Tacms.pkoutput<-function(B,F,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Tacrolimus_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------------\n")
     cat("    --Tacrolimus input data information--             \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1        \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1       \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                 \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)               \n")
     cat("    D = dose for each dosing interval(mg)             \n")
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time(hr)                            \n")  
     cat("    c = measured steady-state conc.(mcg/mL)           \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("-----------------------------------------------------------\n")
     cat("   --Tacrolimus output data information--                  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/mL) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/mL)   \n")
     cat("-----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Enoxaparin including multiple subjects information and predict PK parameters obtained from each single concentration
Enoms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Enoxaparin_subject",i,"  >>\n")
cat("=========================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=========================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-----------------------------------------------------------\n")
     cat("   --Enoxaparin input data information--                   \n")
     cat("   Gender = 1 for Male ; 0 for Female                      \n") 
     cat("   TBW = body weight(kg)                                   \n")   
     cat("   Scr = serum creatinine conc.(mg/dL)                     \n")
     cat("   D = dose for each dosing interval(IU); 1mg = 100 IU     \n")
     cat("   tau = dosing interval(hr)                               \n")
     cat("   Amax = anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Amaxss_pr:\n")
show(F[i,])
     cat("---------------------------------------------------------------------------\n")
     cat("    --Enoxaparin output data information--                                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)                       \n")
     cat("    Amaxss_pr = predicted anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("---------------------------------------------------------------------------\n")
cat("=========================================================================================\n")
cat(date(),"\n")
}}




# output file of Imtinib mesylate including multiple subjects information and predict PK parameters obtained from each single concentration
Imams.pkoutput<-function(B,F,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Imatinib mesylate_subject",i,"  >>\n")
cat("====================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("====================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------------\n")
     cat("    --Imatinib mesylate input data information--      \n")
     cat("    BW = body weight(kg)                              \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                \n")
     cat("    Hb = Hemoglobin (g/dL)                            \n")
     cat("    WBC = white blood count (10^9/L)                  \n")
     cat("    n = dosing number                                 \n") 
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n")
     cat("    c = measured conc.(mg/L)                          \n")
     cat("------------------------------------------------------\n")    
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cm_pr:")
show(F[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("----------------------------------------------------------\n")
     cat("    --Imatinib mesylate output data information--         \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)                \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("====================================================================================\n")
cat(date(),"\n")
}}



# output file of Warfarin including multiple subjects information and predict PK parameters obtained from each single concentration
Warms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Warfarin_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------\n")
     cat("    --Warfarin input data information--         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(day)                  \n")
     cat("    INR = international normalized ratio        \n")
     cat("------------------------------------------------\n")   
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("Cpmax")[i,])                                 
cat("\n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("kc")[i,])                                 
cat("\n")
show(samplesStats("m")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("INR:\n")
show(F[i,])
     cat("----------------------------------------------------------\n")
     cat("  --Warfarin output data information--                    \n")
     cat("  Cpmax = concentration related with maximum suppression  \n")
     cat("          of clotting factors (mg/L)                      \n")
     cat("  cl_F = clerance/bioavailability (L/day)                 \n")
     cat("  kc = first order rate constant for clotting factor      \n")
     cat("       degradation (1/day)                                \n")
     cat("  m = prothrombin complex activity remaining (%/day)      \n")
     cat("  v_F = volume of distribution/bioavailability (L)        \n")
     cat("  INR = predicted international normalized ratio          \n")
     cat("----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Aminophylline anhydrous IR including multiple subjects information and predict PK parameters obtained from each single concentration
Amianhirms.pkoutput<-function(B,F,G,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Aminophylline anhydrous IR_subject",i,"  >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Cpss_pr:")
show(G[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}}



# output file of Aminophylline anhydrous CR including multiple subjects information and predict PK parameters obtained from each single concentration
Amianhcrms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Aminophylline anhydrous CR_subject",i,"  >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous CR input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                              \n")
     cat("    age = age (yr)                                          \n")
     cat("    ht = height (cm)                                        \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                         \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                    \n") 
     cat("    D = dose for each dosing interval (mg)                  \n") 
     cat("    tau = dosing interval (hr)                              \n")
     cat("    C = measured steady-state conc.                         \n")
     cat("------------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
cat("Css_pr:")
show(F[i,])
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous CR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)             \n")
     cat("-----------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}}


# output file of Aminophylline anhydrous iv infusion including multiple subjects information and predict PK parameters obtained from each single concentration
Amianhinfusionms.pkoutput<-function(B,F,K){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Aminophylline anhydrous iv infusion_subject",i,"  >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous iv infusion input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                                       \n")
     cat("    age = age (yr)                                                   \n")
     cat("    ht = height (cm)                                                 \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                                  \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                             \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("---------------------------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>      \n")
show(samplesStats("cl")[i,])                                 
cat("\n")
show(samplesStats("v")[i,])
cat("\n")
cat("Cm_pr:")
show(F[i,])
cat("Ctss_pr:")
show(K[i,])
     cat("---------------------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous iv infusion output data information--   \n")
     cat("   cl = clerance (L/hr)                            \n")
     cat("   V = volume of distribution (L)                  \n")
     cat("   Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}}


# output file of Aminophylline dihydrous IR including multiple subjects information and predict PK parameters obtained from each single concentration
Amidihirms.pkoutput<-function(B,F,G,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Aminophylline dihydrous IR_subject",i,"  >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Cpss_pr:")
show(G[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}}



# output file of Aminophylline dihydrous CR including multiple subjects information and predict PK parameters obtained from each single concentration
Amidihcrms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Aminophylline dihydrous CR_subject",i,"  >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous CR input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                              \n")
     cat("    age = age (yr)                                          \n")
     cat("    ht = height (cm)                                        \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                         \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                    \n") 
     cat("    D = dose for each dosing interval (mg)                  \n") 
     cat("    tau = dosing interval (hr)                              \n")
     cat("    C = measured steady-state conc.                         \n")
     cat("------------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
cat("Css_pr:")
show(F[i,])
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous CR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)             \n")
     cat("-----------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}}





# output file of Aminophylline dihydrous iv infusi including multiple subjects information and predict PK parameters obtained from each single concentration
Amidihinfusionms.pkoutput<-function(B,F,K){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Aminophylline dihydrous iv infusion_subject",i,"  >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous iv infusion input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                                       \n")
     cat("    age = age (yr)                                                   \n")
     cat("    ht = height (cm)                                                 \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                                  \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                             \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("---------------------------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>      \n")
show(samplesStats("cl")[i,])                                 
cat("\n")
show(samplesStats("v")[i,])
cat("\n")
cat("Cm_pr:")
show(F[i,])
cat("Ctss_pr:")
show(K[i,])
     cat("---------------------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous iv infusion output data information--   \n")
     cat("   cl = clerance (L/hr)                            \n")
     cat("   V = volume of distribution (L)                  \n")
     cat("   Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}}


# output file of Oxtriphylline IR including multiple subjects information and predict PK parameters obtained from each single concentration
Oxtirms.pkoutput<-function(B,F,G,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Oxtriphylline IR_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-------------------------------------------------\n")
     cat("    --Oxtriphylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Cpss_pr:")
show(G[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("-----------------------------------------------------------\n")
     cat("   --Oxtriphylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}


# output file of Oxtriphylline CR including multiple subjects information and predict PK parameters obtained from each single concentration
Oxtcrms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Oxtriphylline CR_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
      cat("---------------------------------------------------\n")
     cat("    --Oxtriphylline CR input data information--    \n")
     cat("    Gender = Male=1 ; Female=0                     \n")
     cat("    age = age (yr)                                 \n")
     cat("    ht = height (cm)                               \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                \n")
     cat("    smoke = 1 for a amoker ; otherwise 0           \n") 
     cat("    D = dose for each dosing interval (mg)         \n") 
     cat("    tau = dosing interval (hr)                     \n")
     cat("    C = measured steady-state conc.                \n")
     cat("---------------------------------------------------\n")               
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
cat("Css_pr:")
show(F[i,])
     cat("------------------------------------------------------\n")
     cat("   --Oxtriphylline CR output data information--       \n")
     cat("   cl_F = clerance/bioavailability (L/hr)             \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)        \n")
     cat("------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}



# output file of Theophylline IR including multiple subjects information and predict PK parameters obtained from each single concentration
Theirms.pkoutput<-function(B,F,G,H){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Theophylline IR_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
     cat("-------------------------------------------------\n")
     cat("    --Theophylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
show(samplesStats("v_F")[i,])
cat("\n")
cat("Cmss_pr:")
show(F[i,])
cat("Cpss_pr:")
show(G[i,])
cat("Ctss_pr:")
show(H[i,])
     cat("-----------------------------------------------------------\n")
     cat("   --Theophylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}


# output file of Theophylline CR including multiple subjects information and predict PK parameters obtained from each single concentration
Thecrms.pkoutput<-function(B,F){
for(i in 1:length(unique(B$subject))){
cat("\n\n\n")
cat("Report from tdm   << Theophylline CR_subject",i,"  >>\n")
cat("===============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B[i,])      
      cat("---------------------------------------------------\n")
     cat("    --Theophylline CR input data information--    \n")
     cat("    Gender = Male=1 ; Female=0                     \n")
     cat("    age = age (yr)                                 \n")
     cat("    ht = height (cm)                               \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                \n")
     cat("    smoke = 1 for a amoker ; otherwise 0           \n") 
     cat("    D = dose for each dosing interval (mg)         \n") 
     cat("    tau = dosing interval (hr)                     \n")
     cat("    C = measured steady-state conc.                \n")
     cat("---------------------------------------------------\n")               
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
show(samplesStats("cl_F")[i,])                                 
cat("\n")
cat("Css_pr:")
show(F[i,])
     cat("------------------------------------------------------\n")
     cat("   --Theophylline CR output data information--       \n")
     cat("   cl_F = clerance/bioavailability (L/hr)             \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)        \n")
     cat("------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}}


