% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_symbol_search.R
\name{ref_symbol_search}
\alias{ref_symbol_search}
\title{Reference Data Accessor for Symbol Search from \sQuote{twelvedata}}
\usage{
ref_symbol_search(sym, as = c("data.frame", "raw"), output_size = 30, apikey)
}
\arguments{
\item{sym}{(required, character) Symbol to search for.}

\item{as}{(optional, character) A selector for the desired output format: one of
\dQuote{data.frame} (the default) or or \dQuote{raw}.}

\item{output_size}{(required, character) Defaults to 30. Max is 120.}

\item{apikey}{(optional character) An API key override, if missing a value cached from
package startup is used. The startup looks for either a file in the per-package config
directory provided by \code{tools::R_user_dir} (for R 4.0.0 or later), or the
\code{TWELVEDATA_API_KEY} variable.}
}
\value{
The requested data is returned as a \code{data.frame} object.
}
\description{
Retrieve Reference Data for Symbol Search from \sQuote{twelvedata}
}
\details{
\code{ref_symbol_search}.
}
\seealso{
\url{https://twelvedata.com/docs}
}
