% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHistoricalData.R
\name{getHistoricalData}
\alias{getHistoricalData}
\title{Download Historical Bar Data}
\usage{
getHistoricalData(
  token = "",
  live = FALSE,
  figi = "",
  from = Sys.Date() - 1,
  to = Sys.Date(),
  interval = "hour",
  time_transform = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{figi}{internal tinkoff code for instrument}

\item{from}{from what date download history}

\item{to}{to what date download history}

\item{interval}{timeframe of bars (availible "1min","2min","3min","5min","10min","15min","30min","hour","2hour","4hour","day","week","month")}

\item{time_transform}{trasform time from string to POSIXct}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the requested data with historical bar data (OHLCV).
}
\description{
Makes a request to the server, and returns an data.table object with information about prices of instrument if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getHistoricalData(token,live,figi = 'BBG005HLTYH9')
}
\seealso{
\code{\link{getOrderBook}}
}
\author{
Vyacheslav Arbuzov
}
