% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{signatures}
\alias{signatures}
\title{Sample concentration-response data set from HTTR}
\format{
An object of class \code{data.frame} with 6 rows and 8 columns.
}
\source{
\doi{https://doi.org/10.1093/toxsci/kfab009}
}
\usage{
signatures
}
\description{
A data set containing 6 of the active transcriptional signatures after
perturbation of MCF7 cells with Clomiphene citrate (1:1).
}
\details{
A data frame with 6 rows and 8 variables:
\itemize{
  \item sample_id - experimental sample ID
  \item dtxsid - DSSTox generic substance ID
  \item name - chemical name
  \item signature - transcriptional signature name
  \item cutoff - the 95\% confidence interval from the baseline response (2 lowest concentrations)
  \item onesd - one standard deviation of the baseline response
  \item conc - experimental concentrations, micromolar (uM)
  \item resp - transcriptional signature response for each experimental concentrations, ssGSEA score
}
}
\references{
Joshua A. Harrill, Logan J. Everett, Derik E. Haggard,
  Thomas Sheffield, Joseph L. Bundy, Clinton M. Willis, Russell S. Thomas,
  Imran Shah, Richard S. Judson, High-Throughput Transcriptomics Platform for
  Screening Environmental Chemicals, Toxicological Sciences, Volume 181,
  Issue 1, May 2021, Pages 68 - 89, https://doi.org/10.1093/toxsci/kfab009.
}
\keyword{datasets}
