#' PBT gene sets related to kidney transplant
#'
#'9 Pathogenesis Based Transcripts (PBT) gene sets specifically related to kidney transplant
#'
#'@name PBT_gmt
#'@rdname PBT_gmt
#'@aliases PBT_gmt PBT
#'
#'@usage data(PBT_gmt)
#'
#'@references Halloran PF, De Freitas DG, Einecke G, et al., The molecular phenotype of kidney
#'transplants: Personal viewpoint, \emph{Am J Transplant}, 10: 2215-2222, 2010.
#'.
#'
#'@references Sellares J, Reeve J, Loupy A, et al., Molecular diagnosis of antibody-mediated rejection
#'in human kidney transplants, \emph{Am J Transplant}, 13:971-983, 2013.
#'
#'@references Broin PO, Hayde N, Bao Y, et al.,  A pathogenesis-based transcript signature in
#'donor-specific antibody-positive kidney transplant patients with normal biopsies,
#'\emph{Genomics Data} 2: 357-60, 2014.
#'
#'@format a gmt objects containing 9 gene sets specific to kidney transplant (see \code{\link[GSA:GSA.read.gmt]{GSA.read.gmt}})
#'
#'
#'@examples
#' data("PBT_gmt")
#' PBT_gmt
#'
#'
#' @source \url{http://atagc.med.ualberta.ca/Research/GeneLists}
#'
#' @keywords datasets
#' @docType data
NULL
