% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgsa_seq.R
\name{tcgsa_seq}
\alias{tcgsa_seq}
\title{Time-course Gene Set Analyis}
\usage{
tcgsa_seq(y, x, phi, genesets, indiv = rep(1, nrow(x)),
  Sigma_xi = diag(ncol(phi)), which_test = c("permutation", "asymptotic"),
  which_weights = c("loclin", "voom"), n_perm = 1000,
  preprocessed = FALSE, doPlot = TRUE, bw = "nrd",
  kernel = c("gaussian", "epanechnikov", "rectangular", "triangular",
  "biweight", "tricube", "cosine", "optcosine"), exact = FALSE,
  padjust_methods = c("BH", "BY", "holm", "hochberg", "hommel", "bonferroni"))
}
\arguments{
\item{y}{a numeric matrix of size \code{n x G} containing the raw RNA-seq counts or
preprocessed expressions from \code{n} samples for \code{G} genes.}

\item{x}{a numeric matrix of size \code{n x p} containing the model covariates from
\code{n} samples (design matrix).}

\item{phi}{a numeric design matrix of size \code{n x K} containing the \code{K} variables
to be tested}

\item{genesets}{either a vector of index or subscripts that defines which columns of \code{y}
constitute the invesigated geneset. Can also be a \code{\link[GSA:GSA.read.gmt]{gmt}} \code{list}
when several genesets are tested at once.}

\item{indiv}{a vector of length \code{n} containing the information for
attributing each sample to one of the studied individuals. Coerced
to be a \code{factor}.}

\item{Sigma_xi}{a matrix of size \code{K x K} containing the covariance matrix
of the \code{K} random effects.}

\item{which_test}{a character string indicating which method to use to approximate
the variance component score test, either \code{"permutation"} or \code{"asymptotic"}.
Default is \code{"permutation"}.}

\item{which_weights}{a character string indicating which method to use to estimate
the mean-variance relationship wheights. Possibilities are \code{"loclin"},
\code{"voom"} or \code{NULL} (in which case no weighting is performed).
Default is \code{"loclin"}.
See \code{\link{sp_weights}} and \code{\link{voom_weights}} for details.}

\item{n_perm}{the number of perturbations}

\item{preprocessed}{a logical flag indicating wether the expression data have
already been preprocessed (e.g. log2 transformed). Default is \code{FALSE}, in
which case \code{y} is assumed to contain raw counts and is normalized into
log(counts) per million.}

\item{doPlot}{a logical flag indicating wether the mean-variance plot should be drawn.
Default is \code{FALSE}.}

\item{bw}{a character string indicating the smoothing bandwidth selection method to use. See
\code{\link[stats]{bandwidth}} for details. Possible values are \code{"ucv"}, \code{"SJ"},
\code{"bcv"}, \code{"nrd"} or \code{"nrd0"}}

\item{kernel}{a character string indicating which kernel should be used.
Possibilities are \code{"gaussian"}, \code{"epanechnikov"}, \code{"rectangular"},
\code{"triangular"}, \code{"biweight"}, \code{"tricube"}, \code{"cosine"},
\code{"optcosine"}. Default is \code{"gaussian"} (NB: \code{"tricube"} kernel
corresponds to the loess method).}

\item{exact}{a logical flag indicating wether the non-parametric weights accounting
for the mean-variance relationship should be computed exactly or extrapolated
from the interpolation of local regression of the mean against the
variance. Default is \code{FALSE}, which uses interporlation (faster).}

\item{padjust_methods}{multiple testing correction method used if \code{genesets}
is a list. Default is "BH", i.e. Benjamini-Hochberg procedure for contolling the FDR.
Other possibilities are: \code{"holm"}, \code{"hochberg"}, \code{"hommel"},
\code{"bonferroni"} or \code{"BY"} (for Benjamini-Yekutieli procedure).}
}
\value{
A list with the following elements:\itemize{
  \item \code{which_test}:
  \item \code{preprocessed}:
  \item \code{n_perm}:
  \item \code{pval}: associated p-value
}
}
\description{
Wrapper function for performing gene set analysis of longitudinal RNA-seq data
}
\references{
Agniel D, Hejblum BP, Variance component score test for
time-course gene set analysis of longitudinal RNA-seq data, \emph{submitted}, 2016.

Law, C. W., Chen, Y., Shi, W., & Smyth, G. K. (2014). voom: Precision
weights unlock linear model analysis tools for RNA-seq read counts. \emph{Genome
Biology}, 15(2), R29.
}
\seealso{
\code{\link{sp_weights}} \code{\link{vc_test_perm}} \code{\link{vc_test_asym}} \code{\link{p.adjust}}
}

