% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{topoSort}
\alias{topoSort}
\title{Combine multiple sorted vectors into a single sorted vector}
\usage{
topoSort(vectors, maxIter = 1000, errorIfAmbiguous = FALSE)
}
\arguments{
\item{vectors}{A list of vectors each vector containing sorted elements to be merged into a global sorted vector}

\item{maxIter}{An integer specifying the maximum number of iterations before bailing out. This should be unnecessary and is just a safety feature in case of some unexpected input or bug.}

\item{errorIfAmbiguous}{If TRUE then error if any ambiguities arise}
}
\value{
a vector with all unique elements sorted by the combined ordering provided by the input vectors
}
\description{
Combine multiple sorted vectors into a single vector assuming there are no cycles or weird topologies. Where a global position is ambiguous, the result is placed arbitrarily.
}
\examples{
topoSort(list(c('a','b','f','g'),c('b','e','g','y','z'),c('b','d','e','f','y')))
}
\seealso{
\code{\link{normalizeTaxa}}
}
