% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.R
\name{Extract}
\alias{Extract}
\alias{[}
\alias{[,taxlist-method}
\alias{$,taxlist-method}
\alias{$}
\title{Extract or Replace Parts of taxlist Objects}
\usage{
\S4method{[}{taxlist}(x, i, j, drop = FALSE)

\S4method{$}{taxlist}(x, name)
}
\arguments{
\item{x}{Object of class \linkS4class{taxlist}.}

\item{i, j}{Indices for access.}

\item{drop}{A logical value passed to \code{\link[base]{Extract}}.}

\item{name}{A name to access.}
}
\value{
The method \code{$} retrieves a vector, while \code{[} retrieves a subset
of the input \linkS4class{taxlist} object.
}
\description{
Quick access to slots \code{taxonTraits} and \code{taxonRelations} within
\linkS4class{taxlist} objects.
}
\details{
While the method \code{$} automatically recognizes the slot queried, provided
that there is no shared column names.

In the method \code{[}, the first index is referred to the rows in slot
\code{taxonRelations}, while the second index indicate the columns in slot
\code{taxonTraits}.

A replacement method \verb{$<-} is also implemented.
}
\examples{
## Statistics on life forms
summary(as.factor(Easplist$lf_behn_2018))

## First ten concepts in this list
summary(Easplist[1:10,], "all")

}
\seealso{
\linkS4class{taxlist} \code{\link[taxlist]{subset}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}.
}
