% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tp_search.R
\name{tp_search}
\alias{tp_search}
\title{Search Tropicos by scientific name, common name, or Tropicos ID.}
\usage{
tp_search(
  sci = NULL,
  com = NULL,
  nameid = NULL,
  orderby = NULL,
  sortorder = NULL,
  pagesize = NULL,
  startrow = NULL,
  type = NULL,
  key = NULL,
  name = NULL,
  commonname = NULL,
  ...
)
}
\arguments{
\item{sci}{A scientific name, e.g., "poa annua". See Details.}

\item{com}{A common name, e.g., "annual blue grass"}

\item{nameid}{Your search string. e.g., "25509881"}

\item{orderby}{Your search string. e.g., "1"}

\item{sortorder}{Your search string. e.g., "ascending"}

\item{pagesize}{Your search string. e.g., "100"}

\item{startrow}{Your search string. e.g., "1"}

\item{type}{Type of search, "wildcard" (default) will add a wildcard to
the end of your search string. "exact" will use your search string exactly.}

\item{key}{Your Tropicos API key; See \link{taxize-authentication}
for help on authentication}

\item{name}{Deprecated, see \code{sci}}

\item{commonname}{Deprecated, see \code{com}}

\item{...}{Further args passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
List or dataframe.
}
\description{
Search Tropicos by scientific name, common name, or Tropicos ID.
}
\details{
More details on the \code{name} parameter: Tropicos will fail
if you include a period (\code{.}) in your name string, e.g., \code{var.},
so we replace periods before the request is made to the Tropicos web service.
In addition, Tropicos for some reason doesn't want to see sub-specific rank
names like \code{var}/\code{subsp}, so remove those from your query.
}
\examples{
\dontrun{
tp_search(sci = 'Poa annua')
tp_search(sci = 'Poa annua subsp. annua')
tp_search(sci = 'Poa annua var. annua')
tp_search(sci = 'Poa annua var annua')
tp_search(sci = 'Poa annua annua')
}
}
\references{
\url{http://services.tropicos.org/help?method=SearchNameXml}
}
