% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iucn_id.R
\name{iucn_id}
\alias{iucn_id}
\title{Get an ID for a IUCN listed taxon}
\usage{
iucn_id(sciname)
}
\arguments{
\item{sciname}{character; Scientific name. Should be cleand and in the
format \emph{<Genus> <Species>}. One or more.}
}
\value{
A named list (names are input taxa names) of one or more IUCN IDs.
Taxa that aren't found are silently dropped.
}
\description{
Get an ID for a IUCN listed taxon
}
\details{
Beware: IUCN functions can give back incorrect data. This isn't our fault.
We do our best to get you the correct data quickly, but sometimes IUCN gives
back the wrong data, and sometimes Global Names gives back the wrong data.
We will fix these as soon as possible. In the meantime, just make sure that
the data you get back is correct.
}
\examples{
\dontrun{
iucn_id("Branta canadensis")
iucn_id("Branta bernicla")
iucn_id("Panthera uncia")
iucn_id("Lynx lynx")

# many names
iucn_id(c("Panthera uncia", "Lynx lynx"))

# many names, some not found
iucn_id(c("Panthera uncia", "Lynx lynx", "foo bar", "hello world"))

# a name not found
iucn_id("Foo bar")
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}

