% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boldid.R
\name{get_boldid}
\alias{as.boldid}
\alias{as.boldid.boldid}
\alias{as.boldid.character}
\alias{as.boldid.data.frame}
\alias{as.boldid.list}
\alias{as.boldid.numeric}
\alias{as.data.frame.boldid}
\alias{get_boldid}
\alias{get_boldid_}
\title{Get the BOLD (Barcode of Life) code for a search term.}
\usage{
get_boldid(searchterm, fuzzy = FALSE, dataTypes = "basic",
  includeTree = FALSE, ask = TRUE, verbose = TRUE, rows = NA,
  rank = NULL, division = NULL, parent = NULL, ...)

as.boldid(x, check = TRUE)

\method{as.boldid}{boldid}(x, check = TRUE)

\method{as.boldid}{character}(x, check = TRUE)

\method{as.boldid}{list}(x, check = TRUE)

\method{as.boldid}{numeric}(x, check = TRUE)

\method{as.boldid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{boldid}(x, ...)

get_boldid_(searchterm, verbose = TRUE, fuzzy = FALSE,
  dataTypes = "basic", includeTree = FALSE, rows = NA, ...)
}
\arguments{
\item{searchterm}{character; A vector of common or scientific names.}

\item{fuzzy}{(logical) Whether to use fuzzy search or not (default: FALSE).}

\item{dataTypes}{(character) Specifies the datatypes that will be returned. See Details for
options.}

\item{includeTree}{(logical) If TRUE (default: FALSE), returns a list containing information
for parent taxa as well as the specified taxon.}

\item{ask}{logical; should get_tsn be run in interactive mode?
If TRUE and more than one TSN is found for teh species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; should progress be printed?}

\item{rows}{numeric; Any number from 1 to inifity. If the default NA, all rows are
considered. Note that this function still only gives back a boldid class object with one
to many identifiers. See \code{\link[taxize]{get_boldid_}} to get back all, or a subset,
of the raw data that you are presented during the ask process.}

\item{rank}{(character) A taxonomic rank name. See \code{\link{rank_ref}} for possible
options. Though note that some data sources use atypical ranks, so inspect the
data itself for options. Optional. See \code{Filtering} below.}

\item{division}{(character) A division (aka phylum) name. Optional. See \code{Filtering}
below.}

\item{parent}{(character) A parent name (i.e., the parent of the target search
taxon). Optional. See \code{Filtering} below.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{x}{Input to \code{\link{as.boldid}}}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.boldid}}}
}
\value{
A vector of BOLD ids. If a taxon is not found NA. If more than one BOLD ID is found
   the function asks for user input (if ask = TRUE), otherwise returns NA.
   Comes with an attribute \emph{match} to investigate the reason for NA (either 'not found',
   'found' or if ask = FALSE 'multi match')
}
\description{
Get the BOLD (Barcode of Life) code for a search term.
}
\section{Filtering}{

The parameters \code{division}, \code{parent}, and \code{rank} are not
used in the search to the data provider, but are used in filtering the data down to a
subset that is closer to the target you want.  For all these parameters,
you can use regex strings since we use \code{\link{grep}} internally to match.
Filtering narrows down to the set that matches your query, and removes the rest.
}
\examples{
\dontrun{
get_boldid(searchterm = "Agapostemon")
get_boldid(searchterm = "Chironomus riparius")
get_boldid(c("Chironomus riparius","Quercus douglasii"))
splist <- names_list('species')
get_boldid(splist, verbose=FALSE)

# Fuzzy searching
get_boldid(searchterm="Osmi", fuzzy=TRUE)

# Get back a subset
get_boldid(searchterm="Osmi", fuzzy=TRUE, rows = 1)
get_boldid(searchterm="Osmi", fuzzy=TRUE, rows = 1:10)
get_boldid(searchterm=c("Osmi","Aga"), fuzzy=TRUE, rows = 1)
get_boldid(searchterm=c("Osmi","Aga"), fuzzy=TRUE, rows = 1:3)

# When not found
get_boldid("howdy")
get_boldid(c("Chironomus riparius", "howdy"))
get_boldid('Epicordulia princeps')
get_boldid('Arigomphus furcifer')
get_boldid("Cordulegaster erronea")
get_boldid("Nasiaeshna pentacantha")

# Narrow down results to a division or rank, or both
## Satyrium example
### Results w/o narrowing
get_boldid("Satyrium")
### w/ phylum
get_boldid("Satyrium", division = "Plants")
get_boldid("Satyrium", division = "Animals")

## Rank example
get_boldid("Osmia", fuzzy = TRUE)
get_boldid("Osmia", fuzzy = TRUE, rank = "genus")

# Fuzzy filter on any filtering fields
## uses grep on the inside
get_boldid("Satyrium", division = "anim")
get_boldid("Aga", fuzzy = TRUE, parent = "*idae")

# Convert a boldid without class information to a boldid class
as.boldid(get_boldid("Agapostemon")) # already a boldid, returns the same
as.boldid(get_boldid(c("Agapostemon","Quercus douglasii"))) # same
as.boldid(1973) # numeric
as.boldid(c(1973,101009,98597)) # numeric vector, length > 1
as.boldid("1973") # character
as.boldid(c("1973","101009","98597")) # character vector, length > 1
as.boldid(list("1973","101009","98597")) # list, either numeric or character
## dont check, much faster
as.boldid("1973", check=FALSE)
as.boldid(1973, check=FALSE)
as.boldid(c("1973","101009","98597"), check=FALSE)
as.boldid(list("1973","101009","98597"), check=FALSE)

(out <- as.boldid(c(1973,101009,98597)))
data.frame(out)
as.boldid( data.frame(out) )

# Get all data back
get_boldid_("Osmia", fuzzy=TRUE, rows=1:5)
get_boldid_("Osmia", fuzzy=TRUE, rows=1)
get_boldid_(c("Osmi","Aga"), fuzzy=TRUE, rows = 1:3)

# Curl options
library("httr")
get_boldid(searchterm = "Agapostemon", config=verbose())
get_boldid(searchterm = "Agapostemon", config=progress())

# use curl options
library("httr")
get_boldid("Agapostemon", config=verbose())
bb <- get_boldid("Agapostemon", config=progress())
}
}
\seealso{
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{classification}}
}

