% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{taxa}
\alias{taxa}
\title{A class for multiple taxon objects}
\usage{
taxa(..., .list = NULL)
}
\arguments{
\item{...}{Any number of object of class \code{\link[=taxon]{taxon()}}}

\item{.list}{An alternate to the \code{...} input. Any number of object of class
\code{\link[=taxon]{taxon()}}. Cannot be used with \code{...}.}
}
\value{
An \code{R6Class} object of class \code{Taxon}
}
\description{
Stores one or more \code{\link[=taxon]{taxon()}} objects. This is just a thin wrapper for a list
of \code{\link[=taxon]{taxon()}} objects.
}
\details{
This is the documentation for the class called \code{taxa}. If you are looking for
the documentation for the package as a whole: \link{taxa-package}.
}
\examples{
(a <- taxon(
  name = taxon_name("Poa annua"),
  rank = taxon_rank("species"),
  id = taxon_id(93036)
))
taxa(a, a, a)

# a null set
x <- taxon(NULL)
taxa(x, x, x)

# combo non-null and null
taxa(a, x, a)
}
\seealso{
Other classes: 
\code{\link{hierarchies}()},
\code{\link{hierarchy}()},
\code{\link{taxmap}()},
\code{\link{taxon_database}()},
\code{\link{taxon_id}()},
\code{\link{taxon_name}()},
\code{\link{taxon_rank}()},
\code{\link{taxonomy}()},
\code{\link{taxon}()}
}
\concept{classes}
