% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--docs.R
\name{obs}
\alias{obs}
\title{Get data indexes associated with taxa}
\arguments{
\item{obj}{(\code{\link[=taxmap]{taxmap()}}) The \code{\link[=taxmap]{taxmap()}} object containing taxon information to
be queried.}

\item{data}{Either the name of something in \code{obj$data} that has taxon
information or a an external object with taxon information. For tables,
there must be a column named "taxon_id" and lists/vectors must be named by
taxon ID.}

\item{value}{What data to return. This is usually the name of column in a
table in \code{obj$data}. Any result of \code{all_names(obj)} can be used. If the
value used has names, it is assumed that the names are taxon ids and the
taxon ids are used to look up the correct values.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find observations
for. Default: All taxa in \code{obj} will be used. Any variable name that
appears in \code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own.}

\item{recursive}{(\code{logical} or \code{numeric}) If \code{FALSE}, only return the
observation assigned to the specified input taxa, not subtaxa. If \code{TRUE},
return all the observations of every subtaxa, etc. Positive numbers
indicate the number of ranks below the each taxon to get observations for
\code{0} is equivalent to \code{FALSE}. Negative numbers are equivalent to \code{TRUE}.}

\item{simplify}{(\code{logical}) If \code{TRUE}, then combine all the results into a
single vector of unique observation indexes.}
}
\value{
If \code{simplify = FALSE}, then a list of vectors of observation indexes
are returned corresponding to the \code{target} argument. If \code{simplify = TRUE},
then the observation indexes for all \code{target} taxa are returned in a single
vector.
}
\description{
Given a \code{\link[=taxmap]{taxmap()}} object, return data associated with each taxon in a
given table included in that \code{\link[=taxmap]{taxmap()}} object.
\preformatted{
obj$obs(data, value = NULL, subset = NULL,
  recursive = TRUE, simplify = FALSE)
obs(obj, data, value = NULL, subset = NULL,
  recursive = TRUE, simplify = FALSE)}
}
\examples{
# Get indexes of rows corresponding to each taxon
obs(ex_taxmap, "info")

# Get only a subset of taxon indexes
obs(ex_taxmap, "info", subset = 1:2)

# Get only a subset of taxon IDs
obs(ex_taxmap, "info", subset = c("b", "c"))

# Get only a subset of taxa using logical tests
obs(ex_taxmap, "info", subset = taxon_ranks == "genus")

# Only return indexes of rows assinged to each taxon explicitly
obs(ex_taxmap, "info", recursive = FALSE)

# Lump all row indexes in a single vector
obs(ex_taxmap, "info", simplify = TRUE)

# Return values from a dataset instead of indexes
obs(ex_taxmap, "info", value = "name")

}
