% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{is_stem}
\alias{is_stem}
\title{Test if taxa are stems}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.}
}
\value{
A \code{logical} of length equal to the number of taxa.
}
\description{
Test if taxa are stems in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object. Stems are taxa
from the \code{\link[=roots]{roots()}} taxa to the first taxon with more than one subtaxon. These
can usually be filtered out of the taxonomy without removing any information
on how the remaining taxa are related.
\preformatted{
obj$is_stem()
is_stem(obj)}
}
\examples{
is_stem(ex_taxmap)

}
\seealso{
Other taxonomy data functions: \code{\link{classifications}},
  \code{\link{id_classifications}},
  \code{\link{is_branch}}, \code{\link{is_internode}},
  \code{\link{is_leaf}}, \code{\link{is_root}},
  \code{\link{map_data_}}, \code{\link{map_data}},
  \code{\link{n_subtaxa_1}}, \code{\link{n_subtaxa}},
  \code{\link{n_supertaxa_1}}, \code{\link{n_supertaxa}},
  \code{\link{taxon_ids}}, \code{\link{taxon_indexes}},
  \code{\link{taxon_names}}, \code{\link{taxon_ranks}}
}
