% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_network.R
\name{tar_resources_network}
\alias{tar_resources_network}
\title{Target resources for network file systems.}
\usage{
tar_resources_network(
  max_tries = targets::tar_option_get("resources")$network$max_tries,
  seconds_interval = targets::tar_option_get("resources")$network$seconds_interval,
  seconds_timeout = targets::tar_option_get("resources")$network$seconds_timeout,
  verbose = targets::tar_option_get("resources")$network$verbose
)
}
\arguments{
\item{max_tries}{Positive integer of length 1. Max number of tries.}

\item{seconds_interval}{Positive numeric of length 1.
Multiplier for the exponential backoff algorithm, and width
of the jitter. Units of seconds.}

\item{seconds_timeout}{Positive numeric of length 1. Timeout length in
seconds.}

\item{verbose}{Logical of length 1, whether to print informative
console messages.}
}
\value{
Object of class \code{"tar_resources_network"}, to be supplied
to the network argument of \code{tar_resources()}.
}
\description{
In high-performance computing on network file systems,
if \code{storage = "worker"} in \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}, then
\code{targets} waits for hashes to synchronize before continuing the pipeline.
These resources control the retry mechanism.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.

In \code{targets} version 0.12.2 and above, resources are inherited one-by-one
in nested fashion from \code{tar_option_get("resources")}.
For example, suppose you set
\code{tar_option_set(resources = tar_resources(aws = my_aws))},
where \code{my_aws} equals \code{tar_resources_aws(bucket = "x", prefix = "y")}.
Then, \verb{tar_target(data, get_data()} will have bucket \code{"x"} and
prefix \code{"y"}. In addition, if \code{new_resources} equals
\verb{tar_resources(aws = tar_resources_aws(bucket = "z")))}, then
\code{tar_target(data, get_data(), resources = new_resources)}
will use the new bucket \code{"z"}, but it will still use the prefix \code{"y"}
supplied through \code{tar_option_set()}. (In \code{targets} 0.12.1 and below,
options like \code{prefix} do not carry over from \code{tar_option_set()} if you
supply non-default resources to \code{tar_target()}.)
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name = your_name,
  command = your_command(),
  storage = "worker",
  resources = tar_resources(
    network = tar_resources_network(max_tries = 3)
  )
)
}
}
\seealso{
Other resources: 
\code{\link{tar_resources}()},
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_crew}()},
\code{\link{tar_resources_custom_format}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()}
}
\concept{resources}
