% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_format.R
\name{tar_format}
\alias{tar_format}
\title{Define a custom target storage format.}
\usage{
tar_format(
  read = function(path) {
     readRDS(path)
 },
  write = function(object, path) {
     saveRDS(object = object, file = path, version =
    3L)
 },
  marshal = function(object) {
     identity(object)
 },
  unmarshal = function(object) {
     identity(object)
 },
  repository = NULL
)
}
\arguments{
\item{read}{A function with a single argument named \code{path}.
This function should read and return the target stored
at the file in the argument. It should have no side effects.
See the "Format functions" section for specific requirements.}

\item{write}{A function with two arguments: \code{object} and \code{path},
in that order. This function should save the R object \code{object}
to the file path at \code{path} and have no other side effects.
The return value does not matter.
See the "Format functions" section for specific requirements.}

\item{marshal}{A function with a single argument named \code{object}.
This function should marshal the R object and return
an in-memory object that can be exported to remote parallel workers.
It should not read or write any persistent files.
See the Marshalling section for details.
See the "Format functions" section for specific requirements.}

\item{unmarshal}{A function with a single argument named \code{object}.
This function should unmarshal the (marshalled) R object and return
an in-memory object that is appropriate and valid for use
on a parallel worker. It should not read or write any persistent files.
See the Marshalling section for details.
See the "Format functions" section for specific requirements.}

\item{repository}{Deprecated. Use the \code{repository} argument of
\code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}} instead.}
}
\value{
A character string of length 1 encoding the custom format.
You can supply this string directly to the \code{format}
argument of \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}.
}
\description{
Define a custom target storage format for the
\code{format} argument of \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}.
}
\section{Marshalling}{

If an object can only be used in the R session
where it was created, it is called "non-exportable".
Examples of non-exportable R objects are Keras models,
Torch objects, \code{xgboost} matrices, \code{xml2} documents,
\code{rstan} model objects, \code{sparklyr} data objects, and
database connection objects. These objects cannot be
exported to parallel workers (e.g. for \code{\link[=tar_make_future]{tar_make_future()}})
without special treatment. To send an non-exportable
object to a parallel worker, the object must be marshalled:
converted into a form that can be exported safely
(similar to serialization but not always the same).
Then, the worker must unmarshal the object: convert it
into a form that is usable and valid in the current R session.
Arguments \code{marshal} and \code{unmarshal} of \code{tar_format()}
let you control how marshalling and unmarshalling happens.
}

\section{Format functions}{

In \code{tar_format()}, functions like \code{read}, \code{write},
\code{marshal}, and \code{unmarshal} must be perfectly pure
and perfectly self-sufficient.
They must load or namespace all their own packages,
and they must not depend on any custom user-defined
functions or objects in the global environment of your pipeline.
\code{targets} converts each function to and from text,
so it must not rely on any data in the closure.
This disqualifies functions produced by \code{Vectorize()},
for example.
}

\examples{
# The following target is equivalent to
# tar_target(name, command(), format = "keras"):
tar_target(
  name,
  command(),
  format = tar_format(
    read = function(path) {
       keras::load_model_hdf5(path)
    },
    write = function(object, path) {
      keras::save_model_hdf5(object = object, filepath = path)
    },
    marshal = function(object) {
      keras::serialize_model(object)
    },
    unmarshal = function(object) {
      keras::unserialize_model(object)
    }
  )
)
}
\seealso{
Other targets: 
\code{\link{tar_cue}()},
\code{\link{tar_target_raw}()},
\code{\link{tar_target}()}
}
\concept{targets}
