% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_knit.R
\name{tar_knit_run}
\alias{tar_knit_run}
\title{Run a \code{knitr} report inside a \code{tar_knit()} target.}
\usage{
tar_knit_run(path, working_directory, args, deps)
}
\arguments{
\item{path}{Character string, file path to the \code{knitr} source file.
Must have length 1.}

\item{working_directory}{Optional character string,
path to the working directory
to temporarily set when running the report.
The default is \code{NULL}, which runs the report from the
current working directory at the time the pipeline is run.
This default is recommended in the vast majority of cases.
To use anything other than \code{NULL}, you must manually set the value
of the \code{store} argument relative to the working directory in all calls
to \code{tar_read()} and \code{tar_load()} in the report. Otherwise,
these functions will not know where to find the data.}

\item{args}{A named list of arguments to \code{knitr::knit()}.}

\item{deps}{An unnamed list of target dependencies of the \code{knitr}
report, automatically created by \code{tar_knit()}.}
}
\value{
Character with the path to the \code{knitr} source file
and the relative path to the output \code{knitr} report.
The output path depends on the input path argument,
which has no default.
}
\description{
Internal function needed for \code{tar_knit()}.
Users should not invoke it directly.
}
\keyword{internal}
