% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\docType{class}
\name{ASTNode}
\alias{ASTNode}
\title{A Node in an Abstract Syntax Tree (AST)}
\description{
A Node in an Abstract Syntax Tree (AST)

A Node in an Abstract Syntax Tree (AST)
}
\details{
This is the root R6 class of any term of the AST which is created
when parsing a table formula. This should only be used as a base class
as the class information carries the semantic meaning of a given node.
}
\keyword{data}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{format}}{Any formatting directive passed to this node.}

\item{\code{value}}{A string of addtional information contained by the node.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ASTNode-terms}{\code{ASTNode$terms()}}
\item \href{#method-ASTNode-distribute}{\code{ASTNode$distribute()}}
\item \href{#method-ASTNode-string}{\code{ASTNode$string()}}
\item \href{#method-ASTNode-reduce}{\code{ASTNode$reduce()}}
\item \href{#method-ASTNode-set_format}{\code{ASTNode$set_format()}}
\item \href{#method-ASTNode-clone}{\code{ASTNode$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASTNode-terms"></a>}}
\if{latex}{\out{\hypertarget{method-ASTNode-terms}{}}}
\subsection{Method \code{terms()}}{
Returns this node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASTNode$terms()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASTNode-distribute"></a>}}
\if{latex}{\out{\hypertarget{method-ASTNode-distribute}{}}}
\subsection{Method \code{distribute()}}{
Distributes data across multiplications and rearranges nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASTNode$distribute()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASTNode-string"></a>}}
\if{latex}{\out{\hypertarget{method-ASTNode-string}{}}}
\subsection{Method \code{string()}}{
Returns string representation of node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASTNode$string()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASTNode-reduce"></a>}}
\if{latex}{\out{\hypertarget{method-ASTNode-reduce}{}}}
\subsection{Method \code{reduce()}}{
Given a set of data, associates it with AST nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASTNode$reduce(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(data.frame) data to associate across nodes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASTNode-set_format"></a>}}
\if{latex}{\out{\hypertarget{method-ASTNode-set_format}{}}}
\subsection{Method \code{set_format()}}{
Override the formatting directive for this node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASTNode$set_format(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(numeric,character) the formatting directive}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASTNode-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ASTNode-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASTNode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
