% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop-transformation.R
\name{can_loop_transform_body}
\alias{can_loop_transform_body}
\alias{can_loop_transform_}
\alias{can_loop_transform}
\title{Tests if a function, provided by its name, can be transformed.}
\usage{
can_loop_transform_body(fun_name, fun_body, fun, env)

can_loop_transform_(fun)

can_loop_transform(fun)
}
\arguments{
\item{fun_name}{Name of the recursive function.}

\item{fun_body}{The user-transformed function body.}

\item{fun}{The function to check. Must be provided by its (bare symbol) name.}

\item{env}{Environment used to look up variables used in \code{fun_body}.}
}
\description{
This function analyses a recursive function to check if we can transform it into
a loop or trampoline version with \code{\link{transform}}. Since this function needs to handle
recursive functions, it needs to know the name of its input function, so this must be
provided as a bare symbol.
}
\section{Functions}{
\itemize{
\item \code{can_loop_transform_body}: This version expects \code{fun_body} to be both tested
and user-transformed.

\item \code{can_loop_transform_}: This version expects \code{fun} to be quosure.

\item \code{can_loop_transform}: This version quotes \code{fun} itself.
}}

\examples{
factorial <- function(n)
    if (n <= 1) 1 else n * factorial(n - 1)
factorial_acc <- function(n, acc = 1)
    if (n <= 1) acc else factorial_acc(n - 1, n * acc)

can_loop_transform(factorial)     # FALSE -- and prints a warning
can_loop_transform(factorial_acc) # TRUE

can_loop_transform_(rlang::quo(factorial))     # FALSE -- and prints a warning
can_loop_transform_(rlang::quo(factorial_acc)) # TRUE

}
