% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_one_sample.R
\name{tadaa_one_sample}
\alias{tadaa_one_sample}
\title{Tadaa, one-sample tests!}
\usage{
tadaa_one_sample(data = NULL, x, mu, sigma = NULL,
  direction = "two.sided", na.rm = FALSE, conf.level = 0.95,
  print = c("df", "console", "html", "markdown"))
}
\arguments{
\item{data}{A \code{data.frame} (optional).}

\item{x}{A numeric vector or bare column name of \code{data}.}

\item{mu}{The true mean (\eqn{\mu}) to test for.}

\item{sigma}{Population sigma. If supplied, a z-test is performed,
otherwise a one-sample \link[stats:t.test]{stats::t.test} is performed.}

\item{direction}{Test direction, like \code{alternative} in \link{t.test}.}

\item{na.rm}{Whether to drop \code{NA} values. Default is \code{FALSE}.}

\item{conf.level}{Confidence level used for power and CI, default is \code{0.95}.}

\item{print}{Print method, default \code{df}: A regular \code{data.frame}.
Otherwise passed to \link[pixiedust:sprinkle_print_method]{pixiedust::sprinkle_print_method} for fancyness.}
}
\value{
A \code{data.frame} by default, otherwise \code{dust} object, depending on \code{print}.
}
\description{
If \code{sigma} is omitted, the function will just perform a one-sample \link[stats:t.test]{stats::t.test},
but if \code{sigma} is provided, a z-test is performed. It basically works the same way,
except that we pretend we know the population sigma and use the normal distribution
for comparison.
}
\examples{
set.seed(42)
df <- data.frame(x = rnorm(n = 20, mean = 100, sd = 1))

tadaa_one_sample(df, x, mu = 101, sigma = 1)

# No data.frame, just a vector
tadaa_one_sample(x = rnorm(20), mu = 0)
}
\seealso{
Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_chisq}}, \code{\link{tadaa_kruskal}},
  \code{\link{tadaa_levene}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_normtest}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_pairwise_gh}},
  \code{\link{tadaa_pairwise_tukey}},
  \code{\link{tadaa_pairwise_t}},
  \code{\link{tadaa_t.test}}, \code{\link{tadaa_wilcoxon}}
}
