% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_chao1}
\alias{index_chao1}
\alias{index_chao1-method}
\alias{index_chao1,numeric-method}
\title{Chao1 Estimator}
\usage{
index_chao1(x, ...)

\S4method{index_chao1}{numeric}(x, unbiased = FALSE, improved = FALSE, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{unbiased}{A \code{\link{logical}} scalar: should the bias-corrected estimator be
used?}

\item{improved}{A \code{\link{logical}} scalar: should the improved estimator be used?}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Chao1 Estimator
}
\references{
Chao, A. (1984). Nonparametric Estimation of the Number of Classes in a
Population. \emph{Scandinavian Journal of Statistics}, 11(4), 265-270.

Chiu, C.-H., Wang, Y.-T., Walther, B. A. & Chao, A. (2014). An improved
nonparametric lower bound of species richness via a modified good-turing
frequency formula. \emph{Biometrics}, 70(3), 671-682.
\doi{10.1111/biom.12200}.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
