% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_ford.R
\docType{methods}
\name{plot_ford}
\alias{plot_ford}
\alias{plot_ford-method}
\alias{Ford}
\alias{plot_ford,matrix-method}
\alias{plot_ford,data.frame-method}
\title{Ford Diagram}
\usage{
plot_ford(object, ...)

\S4method{plot_ford}{matrix}(object, EPPM = FALSE)

\S4method{plot_ford}{data.frame}(object, EPPM = FALSE)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each class).}

\item{...}{Currently not used.}

\item{EPPM}{A \code{\link{logical}} scalar: should the EPPM be drawn?
This argument is defunct: use \code{seriograph()} instead.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a Ford (battleship curve) diagram.
}
\examples{
## Ceramic data
## (data from Desachy 2004)
data("compiegne", package = "folio")

## Plot a Ford diagram
plot_ford(compiegne)
}
\references{
Ford, J. A. (1962). \emph{A quantitative method for deriving cultural
chronology}. Washington, DC: Pan American Union. Technical manual 1.
}
\seealso{
Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_bertin}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_diversity}},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_spot}()},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
