% Auto-generated documentation for function update.pltdTable 
%  2020-11-29 11:21:55 
\name{update.pltdTable}
\alias{update.pltdTable}
\title{Update a \code{pltdtable} (Plotted Table) Object }
\description{
Update a \code{pltdTable} (plotted table) object with new styles or
scaling.
}
\usage{
\method{update}{pltdTable}(object, entryStyle=NULL, blockStyle=NULL, hvruleStyle=NULL, 
    scale=NULL, plot.margin=attr(object, "plot.margin"), 
    sizeAdjust=attr(object, "sizeAdjust"), ...)
}
\arguments{
  \item{object}{A \code{pltdTable} object, containing a plotted table.
  }
  \item{entryStyle, blockStyle, hvruleStyle}{Optional \code{styleObj} objects, specifying new styles for assigning
graphical properties to table entries, blocks, or hvrules.  The default
value of NULL leaves the corresponding style of \code{object} unchanged.
  }
  \item{scale}{Optional numeric multiplier used to increase or decrease the displayed
size of table elements, relative to the natural size implied by their
(updated) styles.  If it has length two, the first element applies to
entries and blocks, and the second to hvrules.  The default is to use a
value of 1.0 for element types with new styles, and to not change the
scaling for element types whose styles are not updated.
  }
  \item{plot.margin, sizeAdjust}{See the documentation for \code{plot.textTable}.  The default is to use
the same values that were used to create \code{object}.
  }
  \item{...}{Ignored, with a warning.  (Included for compatibility with the generic.)
  }
}
\value{
An object of S3 class \code{pltdTable}, inheriting from \code{ggplot}.
See \code{plot.textTable} for details about this object.
}
\details{
Updating a plotted table is limited to changing its style or
scale--changes that do not affect the augmented row-column grid of the
table.  (See \code{adim} for a description of that grid.)  For other
changes, start with a \code{textTable} object, and edit it and/or replot
it using different arguments (e.g., \code{rowheadInside},
\code{rowgroupSize}, \code{mergeRuns}, or annotation).

Updating does not change the \code{enabled} field for any entries, blocks,
or existing hvrules.

When argument \code{hvruleStyle} is provided, hvrules are regenerated by
applying the style to the blocks component of \code{object}.  These new
hvrules replace any existing hvrules with the same ID.  However existing
hvrules with other ID's are left unchanged.
}
\seealso{
\code{\link{plot.textTable}}, \code{\link{styleObj}}
}
\examples{
# Plot using 'factory-fresh' entry style:
plt <- plot(textTable(iris2_tab), entryStyle=styles_pkg$entryStyle_pkg_1)
# Change to a generic style that uses the same graphical properties for 
# all entries:
plt2 <- update(plt, entryStyle=styles_pkg$entryStyle_pkg_base)
plt2
# Also make the plot smaller:
plt3 <- update(plt2, scale=0.8)
plt3
  }
