% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_table_extra.R
\name{get_table_extra_dimensions}
\alias{get_table_extra_dimensions}
\title{Get width and height of the plot.}
\usage{
get_table_extra_dimensions(
  dscale,
  dcolor,
  theme,
  rows_more = NULL,
  cols_more = NULL,
  unit = "inches",
  dscale_title_legend = NULL,
  dcolor_title_legend = NULL,
  margin_x = unit(1, "inches"),
  margin_y = unit(1, "inches")
)
}
\arguments{
\item{dscale}{a matrix containing the values defining the grobs scales.}

\item{dcolor}{(optional) a matrix of size (n,m) containing the values defining the grobs colors.}

\item{theme}{a list of theme parameters. Use an instance of \code{ttheme_awesome}.}

\item{rows_more}{(optional) a named list of additional columns (right-part) of the plot for describing the rows. The
list names will be used as column headers.}

\item{cols_more}{(optional) a named list of additional rows (top-part) of the plot for describing the columns The
list names will be used as row headers.}

\item{unit}{(optional) choose any unit that is valid for \code{grid::unit}.}

\item{dscale_title_legend}{(optional) title for the colorbar providing a legend for scales.}

\item{dcolor_title_legend}{(optional) title for the colorbar providing a legend for colors}

\item{margin_x}{(optional) use it to fine-tune the width of the plot if some elements are not displayed correctly.}

\item{margin_y}{(optional) use it to fine-tune the height of the plot if some elements are not displayed correctly.}
}
\value{
a list with dimensions of the global plot and of parts of the plot.
}
\description{
Compute the width and height in user-specified unit required for drawing the plot.
}
\author{
Yoann Pradat
}
\keyword{internal}
